package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * 版权：    上海云砺信息科技有限公司
 * 创建者:   youyifan
 * 创建时间: 2/8/2020 4:14 PM
 * 功能描述:
 * 修改历史:
 */
public enum PfcpEnvStatus {

    /**
     * 未发布
     */
    UP("UP","运行中"),
    /**
     * 已发布
     */
    DOWN("DOWN","已停用");

    private String code;
    private String desc;

    PfcpEnvStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static PfcpEnvStatus fromCode(String code) {
        return Stream.of(PfcpEnvStatus.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
