package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/6/21 14:21
 * Description:
 * History:
 */
public enum RoleType {

    DEVELOPER("developer", "开发者"),
    ADMIN("admin", "管理者"),
    DEV_OPS("devOps", "运维者"),
    SUPER("root", "超级");

    private String code;

    private String desc;

    RoleType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() { return desc; }

    public static RoleType fromCode(String code) {
        return Stream.of(RoleType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
