package com.xforceplus.ultraman.bocp.metadata.enums;

/**
 * @author leo
 * Defines the various stages of a state flow event in a finite state machine.
 */
public enum StateFlowEventStage {

    /**
     * Event stage indicating that the state machine has just entered a new state.
     * This event is fired when the state machine transition results in a change
     * of state, just after the new state is entered.
     */
    STATE_ENTRY,

    /**
     * Event stage indicating that the state machine is about to exit a state.
     * This event is fired when the state machine is transitioning from the current
     * state to a new state, just before the current state is exited.
     */
    STATE_EXIT,

    /**
     * Event stage indicating that a state transition is beginning.
     * This event is fired just before a state transition begins.
     */
    TRANSITION_BEGIN,

    /**
     * Event stage indicating that a state transition has been successfully completed.
     * This event is fired after a state transition has been successfully carried out.
     */
    TRANSITION_SUCCESS,

    /**
     * Event stage indicating that a state transition has failed.
     * This event is fired if an error occurs during a state transition.
     */
    TRANSITION_FAILED;
}

