package com.xforceplus.ultraman.bocp.metadata.enums;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/11/23 09:41
 * Description:
 * History:
 */
public enum SysEnvType {
    DEV("0", "dev"),
    FAT("1", "fat"),
    PROD("2", "prod"),
    SIT("3", "sit"),
    DEMO("5", "demo");

    private String code;
    private String desc;

    private SysEnvType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return this.code;
    }

    public String desc() {
        return this.desc;
    }

    public static SysEnvType fromCode(String t) {
        if (t == null) {
            return null;
        } else {
            switch (t) {
                case "0":
                    return DEV;
                case "1":
                    return FAT;
                case "2":
                    return PROD;
                case "3":
                    return SIT;
                case "5":
                    return DEMO;
                default:
                    return null;
            }
        }
    }
}
