package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * 字段类型
 *
 * @className: FieldType
 * @package: com.xforceplus.ultraman.bocp.metadata.bo.enums.enums
 * @author: wangzheng
 * @date: 2021/3/4 17:39
 */
public enum SystemFieldCodeEnum {
    NORMAL(""),
    TENANT_ID("tenant_id"),
    TENANT_CODE("tenant_code"),
    CREATE_TIME("create_time"),
    UPDATE_TIME("update_time"),
    CREATE_USER_ID("create_user_id"),
    UPDATE_USER_ID("update_user_id"),
    CREATE_USER_NAME("create_user_name"),
    UPDATE_USER_NAME("update_user_name"),
    DELETE_FLAG("delete_flag");

    private String code;

    SystemFieldCodeEnum(String code) {
        this.code = code;
    }

    public String code() {
        return code;
    }

    public static SystemFieldCodeEnum getValue(String code) {
        return Stream.of(SystemFieldCodeEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(NORMAL);
    }
}
