package com.xforceplus.ultraman.bocp.metadata.enums;

import java.util.stream.Stream;

/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2021/1/29 8:25 PM
 */
public enum TriggerType {

    /**
     * 状态触发
     */
    STATE(0,"对象状态触发"),
    /**
     * 转移触发
     */
    TRANSITION(1,"状态流转移触发"),
    /**
     * 对象触发
     */
    ENTITY(2,"对象增删改触发"),
    /**
     * 任务触发
     */
    JOB(3,"JOB触发"),
    /**
     * 自定义事件触发
     */
    BUSINESS_CODE(4,"业务代码触发"),
    /**
     * 自动化流中触发抛出事件
     */
    AUTOMATIC_FLOW(5,"自动化流触发");



    private Integer value;
    private String description;

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    TriggerType(Integer value, String description) {
        this.value = value;
        this.description = description;
    }

    public Integer value() {
        return this.value;
    }

    public static TriggerType fromValue(Integer value) {
        return Stream.of(TriggerType.values())
                .filter(t -> t.value().equals(value))
                .findFirst().orElseThrow(() -> new IllegalArgumentException("不存在的触发类型！"));
    }

}
