package com.xforceplus.ultraman.bocp.metadata.flow.mapstruct;

import com.xforceplus.ultraman.bocp.metadata.flow.vo.FlowSettingVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/4/8 17:09
 * Description:
 * History:
 */
@Mapper
public interface FlowSettingStructMapper {
    FlowSettingStructMapper MAPPER = Mappers.getMapper(FlowSettingStructMapper.class);

    FlowSetting clone(FlowSetting flowSetting);

    FlowSettingVo toVo(FlowSetting flowSetting);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "extendAttribute", target = "extendAttribute")
    @Mapping(source = "flowSetting", target = "flowSetting")
    @Mapping(source = "flowSettingFront", target = "flowSettingFront")
    @Mapping(source = "flowType", target = "flowType")
    @Mapping(source = "status", target = "status")
    void update(FlowSetting newFlowSetting, @MappingTarget FlowSetting flowSetting);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "code", source = "code")
    @Mapping(target = "name", source = "name")
    @Mapping(target = "remark", source = "remark")
    @Mapping(target = "extendAttribute", source = "extendAttribute")
    @Mapping(target = "flowSetting", source = "flowSetting")
    @Mapping(target = "flowSettingFront", source = "flowSettingFront")
    @Mapping(target = "flowType", source = "flowType")
    @Mapping(target = "version", source = "version")
    @Mapping(target = "status", source = "status")
    void recover(FlowSetting vEntity, @MappingTarget FlowSetting currentEntity);
}
