package com.xforceplus.ultraman.bocp.metadata.janus.enums;

public enum JanusApiType {
    AUTH("auth"),
    SERVICE("service"),
    SERVICE_TCP("service_tcp"),
    ;
    private String value;

    JanusApiType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public static JanusApiType fromValue(String value) {
        if (null != value) {
            for (JanusApiType mt : JanusApiType.values()) {
                if (mt.getValue().equalsIgnoreCase(value)) {
                    return mt;
                }
            }
        }
        return null;
    }

}
