package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/4/8 17:09
 * Description:
 * History:
 */
@Mapper
public interface AppEventStructMapper {
    AppEventStructMapper MAPPER = Mappers.getMapper(AppEventStructMapper.class);

    AppEvent clone(AppEvent appEvent);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "eventName", target = "eventName")
    @Mapping(source = "eventCode", target = "eventCode")
    @Mapping(source = "eventType", target = "eventType")
    @Mapping(source = "eventSource", target = "eventSource")
    @Mapping(source = "eventDataSchema", target = "eventDataSchema")
    @Mapping(source = "eventRemark", target = "eventRemark")
    void update(AppEvent newAppEvent, @MappingTarget AppEvent appEvent);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "eventName", source = "eventName")
    @Mapping(target = "eventCode", source = "eventCode")
    @Mapping(target = "eventType", source = "eventType")
    @Mapping(target = "eventSource", source = "eventSource")
    @Mapping(target = "eventDataSchema", source = "eventDataSchema")
    @Mapping(target = "eventRemark", source = "eventRemark")
    @Mapping(target = "version", source = "version")
    void recover(AppEvent vEntity, @MappingTarget AppEvent currentEntity);
}
