package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.DictDetail;
import com.xforceplus.ultraman.bocp.metadata.vo.DictDetailVo;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 9/9/2020 11:29 AM
 * @description:
 * @history:
 */
@Mapper(nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.IGNORE)
public interface DictDetailStructMapper {
    DictDetailStructMapper MAPPER = Mappers.getMapper(DictDetailStructMapper.class);

    @Mapping(source = "value", target = "code")
    @Mapping(source = "text", target = "name")
    @Mapping(source = "text", target = "remark")
    @Mapping(source = "icon", target = "icon")
    DictDetail toEntity(DictDetailVo dictDetailVo);

    @Mapping(source = "id", target = "id")
    @Mapping(source = "code", target = "value")
    @Mapping(source = "name", target = "text")
    @Mapping(source = "icon", target = "icon")
    DictDetailVo toVo(DictDetail dictDetail);

    DictDetail clone(DictDetail dictDetail);

    void updateEntity(DictDetail newDictDetail, @MappingTarget DictDetail dictDetail);

    @Mapping(target = "id", ignore = true)
    @Mapping(target = "uniqueId", ignore = true)
    @Mapping(target = "version", expression = "java(\"0.0.0\")")
    @Mapping(target = "createUser", ignore = true)
    @Mapping(target = "createUserName", ignore = true)
    @Mapping(target = "createTime", ignore = true)
    @Mapping(target = "updateUser", ignore = true)
    @Mapping(target = "updateUserName", ignore = true)
    @Mapping(target = "updateTime", ignore = true)
    DictDetail createUDictDetailFromSysDictDetail(DictDetail o);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "icon", target = "icon")
    void updateUDictDetailFromSysDictDetail(DictDetail sys, @MappingTarget DictDetail dictDetail);

    @Mapping(target = "id", ignore = true)
    @Mapping(source = "value", target = "code")
    @Mapping(source = "text", target = "name")
    @Mapping(source = "text", target = "remark")
    @Mapping(source = "icon", target = "icon")
    void updateEntityFromVo(DictDetailVo dictDetailVo, @MappingTarget DictDetail dictDetail);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "icon", target = "icon")
    @Mapping(source = "version", target = "version")
    void recover(DictDetail vEntity, @MappingTarget DictDetail currentEntity);
}
