package com.xforceplus.ultraman.bocp.metadata.mapstruct;

import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowAction;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/4/8 17:09
 * Description:
 * History:
 */
@Mapper
public interface FlowActionStructMapper {
    FlowActionStructMapper MAPPER = Mappers.getMapper(FlowActionStructMapper.class);

    FlowAction clone(FlowAction flowAction);

    void updateEntity(FlowAction newFlowAction, @MappingTarget FlowAction flowAction);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "actionCode", target = "actionCode")
    @Mapping(source = "actionName", target = "actionName")
    @Mapping(source = "actionType", target = "actionType")
    @Mapping(source = "actionBusinessType", target = "actionBusinessType")
    @Mapping(source = "actionContent", target = "actionContent")
    @Mapping(source = "actionDesc", target = "actionDesc")
    void update(FlowAction newFlowAction, @MappingTarget FlowAction flowAction);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(target = "actionName", source = "actionName")
    @Mapping(target = "actionType", source = "actionType")
    @Mapping(target = "actionBusinessType", source = "actionBusinessType")
    @Mapping(target = "actionCode", source = "actionCode")
    @Mapping(target = "actionContent", source = "actionContent")
    @Mapping(target = "actionDesc", source = "actionDesc")
    @Mapping(target = "version", source = "version")
    void recover(FlowAction vEntity, @MappingTarget FlowAction currentEntity);
}
