package com.xforceplus.ultraman.bocp.metadata.rule.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2020/5/28 11:07 PM
 */
@Data
@ApiModel(value =  "FunctionAddRequest",description = "函数添加请求实结构体")
public class FunctionAddRequest {

    @ApiModelProperty(value = "functionId",required = false)
    private Long functionId;

    @ApiModelProperty(value = "应用Id",required = true)
    private String appId;

    /**
     * 函数名称
     */
    @ApiModelProperty(value = "函数名称",required = true)
    private String functionName;

    /**
     * 函数内容
     */
    @ApiModelProperty(value = "函数内容",required = true)
    private String functionContent;

    /**
     * 函数功能说明
     */
    @ApiModelProperty(value = "函数功能说明",required = false)
    private String functionDesc;

    /**
     * 函数例子
     */
    @ApiModelProperty(value = "函数举例",required = false)
    private String functionExample;

    /**
     * 函数tag编码
     */
    @ApiModelProperty(value = "函数tag编码",required = false)
    private String tagCode;

    /**
     * 函数类型：0:系统内置类型 1:通用自定义函数 2:应用自定义函数
     */
    @ApiModelProperty(value = "函数类型",required = true)
    private Integer functionType;


    @ApiModelProperty(value = "函数参数列表",required = true)
    private List<FunctionParam> paramList;



}
