package com.xforceplus.ultraman.bocp.metadata.rule.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 项目名称: 票易通
 * JDK 版本: JDK1.8
 * 说明:
 * 作者(@author): liwei
 * 创建时间: 2020/5/29 9:50 AM
 */
@Data
@ApiModel(value = "FunctionParam",description = "函数参数结构体")
public class FunctionParam {


    /**
     * 参数名称
     */
    @ApiModelProperty(value = "参数名称",required = true)
    private String paramName;

    /**
     * 参数类型
     */
    @ApiModelProperty(value = "参数类型",required = true)
    private String paramType;

    /**
     * 0:入参 1:出参
     */
    @ApiModelProperty(value = "参数方向 1 :出参 0:入参数",required = false)
    private Integer paramDirect;

    /**
     * 参数顺序
     */
    @ApiModelProperty(value="参数顺序",required = true)
    private Integer paramSort;

    /**
     * 参数分类
     */
    @ApiModelProperty(value = "参数分类 0：基础类型 1：元数据对象 2：枚举对象 3：基础类型集合 4：元数据集合")
    private Integer paramClassification;


    /**
     * 元数据对象标识
     */
    @ApiModelProperty(value = "元数据对象标识")
    private String paramObjCode;


    /**
     * 参数ID
     */
    @ApiModelProperty(value = "参数ID",required = false)
    private Long id;


    /**
     * 是否必须填写
     */
    @ApiModelProperty(value = "是否必填",required = false)
    private Integer required;

}
