package com.xforceplus.ultraman.bocp.metadata.sdkSetting.enums;

import com.xforceplus.ultraman.bocp.metadata.enums.AppType;

import java.util.stream.Stream;

/**
 * @author leo
 * Defines the various stages of a state flow event in a finite state machine.
 */
public enum SdkSettingType {

    SDK20("sdk20");

    private String code;

    SdkSettingType(String code) {
        this.code = code;
    }

    public String code() {
        return code;
    }

    public static SdkSettingType fromCode(String code) {
        return Stream.of(SdkSettingType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(SDK20);
    }
}

