package com.xforceplus.ultraman.bocp.metadata.version.enums;

import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 6/3/2021 6:35 PM
 * @description:
 * @history:
 */
public enum MetadataRecoveryType {
    /**
     * 对象
     */
    BO("bo","对象"),
    BO_FIELD("boField","对象字段"),
    BO_API("boApi","对象接口"),
    BO_RELATIONSHIP("boRelationship","对象关系"),
    BO_INDEX("boIndex","对象索引"),
    BO_DATA_RULE("boDataRule","对象默认权限"),
    /**
     * 字典
     */
    DICT("dict","字典"),
    DICT_DETAIL("dictDetail","字典项"),
    /**
     * 页面
     */
    PAGE("page", "页面"),
    PAGE_BO_SETTING("pageBoSetting", "页面对象配置"),
    /**
     * 表单
     */
    FORM("form", "表单"),
    /**
     * 流动作
     */
    FLOW_ACTION("flowAction","自定义ACTION"),
    FLOW_ACTION_PARAM("flowActionParam","自定义ACTION参数"),

    /**
     * 流配置
     */
    FLOW_SETTING("flowSetting","流配置"),

    /**
     * 接口
     */
    API("api", "接口"),
    /**
     * 规则
     */
    RULE("rule", "规则"),
    RULE_PARAM("ruleParam", "规则参数"),
    /**
     * 标签
     */
    TAG("tag", "标签"),
    /**
     * 应用事件
     */
    APP_EVENT("appEvent", "应用事件"),
    APP_EVENT_SUBSCRIBE("appEventSubscribe", "应用事件订阅"),
    /**
     * SDK配置
     */
    SDK_SETTING("sdkSetting","SDK配置"),

    PAGE_SETTING("pageSetting", "新页面配置");

    private String code;
    private String desc;

    MetadataRecoveryType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static MetadataRecoveryType fromCode(String code) {
        return Stream.of(MetadataRecoveryType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }

}
