package com.xforceplus.ultraman.bocp.metadata.version.enums;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 6/3/2021 6:35 PM
 * @description:
 * @history:
 */
public enum MetadataType {
    /**
     * 对象
     */
    BO("bo","对象"),
    /**
     * 字典
     */
    DICT("dict","字典"),
    /**
     * 页面
     */
    PAGE("page", "页面"),
    /**
     * 表单
     */
    FORM("form", "表单"),

    /**
     * 流动作
     */
    FLOW_ACTION("flowAction","流动作"),

    /**
     * 流配置
     */
    FLOW_SETTING("flowSetting","流配置"),

    /**
     * 接口
     */
    API("api", "接口"),
    /**
     * 规则
     */
    RULE("rule", "规则"),
    /**
     * 标签
     */
    TAG("tag", "标签"),
    /**
     * 应用事件
     */
    APP_EVENT("appEvent", "应用事件"),
    /**
     * SDK配置
     */
    SDK_SETTING("sdkSetting","SDK配置"),

    PAGE_SETTING("pageSetting", "新页面配置");

    private String code;
    private String desc;

    MetadataType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static MetadataType fromCode(String code) {
        return Stream.of(MetadataType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }

    public static List<String> getCodes() {
        return Stream.of(MetadataType.values()).map(MetadataType::code).collect(Collectors.toList());
    }
}
