package com.xforceplus.ultraman.bocp.metadata.version.enums;

import java.util.stream.Stream;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2023/9/5 13:04
 * Description:
 * History:
 */
public enum VersionCreateType {
    DEFAULT("default", "默认"),
    MULTI_TENANT("multi_tenant", "标准和租户定制");

    private String code;
    private String desc;

    VersionCreateType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String code() {
        return code;
    }

    public String desc() {
        return desc;
    }

    @Override
    public String toString() {
        return desc + "(" + code + ")";
    }

    public static VersionCreateType fromCode(String code) {
        return Stream.of(VersionCreateType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
