package com.xforceplus.ultraman.bocp.metadata.view.mapstruct;

import com.xforceplus.ultraman.bocp.metadata.view.vo.UltFormExVo;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 6/25/2021 4:20 PM
 * @description:
 * @history:
 */
@Mapper
public interface UltFormStructMapper {
    UltFormStructMapper MAPPER = Mappers.getMapper(UltFormStructMapper.class);

    UltForm clone(UltForm ultForm);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "setting", target = "setting")
    @Mapping(source = "refFormId", target = "refFormId")
    @Mapping(source = "version", target = "version")
    @Mapping(source = "updateUser", target = "updateUser")
    @Mapping(source = "updateUserName", target = "updateUserName")
    @Mapping(source = "updateTime", target = "updateTime")
    void updateForm(UltForm form, @MappingTarget UltForm newForm);

    UltFormExVo toUltFormExVo(UltForm ultForm);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "alias", target = "alias")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "boCode", target = "boCode")
    @Mapping(source = "boName", target = "boName")
    @Mapping(source = "setting", target = "setting")
    @Mapping(source = "status", target = "status")
    @Mapping(source = "version", target = "version")
    void recover(UltForm vEntity, @MappingTarget UltForm currentEntity);
}
