package com.xforceplus.ultraman.bocp.metadata.view.mapstruct;

import com.xforceplus.ultraman.bocp.metadata.view.vo.UltPageSettingExVo;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPageSetting;
import org.mapstruct.*;
import org.mapstruct.factory.Mappers;

/**
 * @copyright： 上海云砺信息科技有限公司
 * @author: youyifan
 * @createTime: 6/25/2021 4:20 PM
 * @description:
 * @history:
 */
@Mapper
public interface UltPageSettingStructMapper {
    UltPageSettingStructMapper MAPPER = Mappers.getMapper(UltPageSettingStructMapper.class);

    UltPageSetting clone(UltPageSetting ultPageSetting);

    @BeanMapping(ignoreByDefault = true)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "setting", target = "setting")
    @Mapping(source = "version", target = "version")
    @Mapping(source = "updateUser", target = "updateUser")
    @Mapping(source = "updateUserName", target = "updateUserName")
    @Mapping(source = "updateTime", target = "updateTime")
    void updatePageSetting(UltPageSetting pageSetting, @MappingTarget UltPageSetting newPageSetting);

    UltPageSettingExVo toUltPageSettingExVo(UltPageSetting ultPageSetting);

    @BeanMapping(ignoreByDefault = true, nullValuePropertyMappingStrategy = NullValuePropertyMappingStrategy.SET_TO_NULL)
    @Mapping(source = "name", target = "name")
    @Mapping(source = "code", target = "code")
    @Mapping(source = "alias", target = "alias")
    @Mapping(source = "remark", target = "remark")
    @Mapping(source = "setting", target = "setting")
    @Mapping(source = "status", target = "status")
    void recover(UltPageSetting vEntity, @MappingTarget UltPageSetting currentEntity);
}
