package com.xforceplus.ultraman.bocp.metadata.vo;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.xforceplus.ultraman.bocp.metadata.deserialize.JsonToStringDeserializer;
import com.xforceplus.ultraman.bocp.metadata.deserialize.StringToJsonSerializer;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

/**
 * CopyRight: 上海云砺信息科技有限公司
 * User: youyifan
 * DateTime: 2022/5/31 10:51
 * Description:
 * History:
 */
@Data
@Accessors(chain = true)
public class BoDataRuleVo {

    /**
     * ID
     */
    private Long id;

//    /**
//     * 应用ID
//     */
//    private Long appId;
//
//    /**
//     * 实体ID
//     */
//    private Long boId;

    private Long envId;

    /**
     * 租户定制的标准对象ID
     */
    private Long refEntityId;

    /**
     * 规则名称
     */
    private String name;

//    /**
//     * 规则代码
//     */
//    private String code;

    /**
     * 规则类型 default | custom
     */
    private String type;

    private String customType;

//    /**
//     * 说明信息
//     */
//    private String remark;
    /**
     * 字段
     */
    private String rowField;

    /**
     * 对象操作 query|create|modify|delete
     */
    private String entityAction;

    /**
     * 租户范围
     */
    @JsonSerialize(using = StringToJsonSerializer.class)
    @JsonDeserialize(using = JsonToStringDeserializer.class)
    private String tenantScope;

    /**
     * 行权限类型 all|user|orgId|orgCode|custom
     */
    private String rowRuleType;

    /**
     * 行权限规则
     */
    @JsonSerialize(using = StringToJsonSerializer.class)
    @JsonDeserialize(using = JsonToStringDeserializer.class)
    private String rowRule;

    /**
     * 列权限规则
     */
    private String columnRule;

    /**
     * 默认规则集处理方式 intersection|union
     */
    private String defaultRuleOp;

    /**
     * 应用状态
     */
    private String status;

    private Long updateUser;

    private String updateUserName;

    private LocalDateTime updateTime;

    private Long createUser;

    private String createUserName;

    private LocalDateTime createTime;
}
