package com.xforceplus.ultraman.bocp.metadata.vo;

import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;

@Data
@Accessors(chain = true)
public class BoFieldDomainVo {
    /**
     * 表id
     */
    private Long id;

    /**
     * 全局id
     */
    private Long uniqueId;

    /**
     * 租户id
     */
    private Long tenantId;

    /**
     * 租户信息
     */
    private String tenantCode;

    /**
     * 业务对象id
     */
    private Long boId;

    /**
     * 来源字段ID
     */
    private Long fieldId;

    /**
     * 引用字段-用于租户定制等
     */
    private Long refFieldId;

    /**
     * 同步字段Id
     */
    private Long syncFieldId;

    /**
     * 发布字段id
     */
    private Long publishFieldId;

    /**
     * 发布标识
     */
    private String publishFlag;

    /**
     * 名称
     */
    private String name;

    /**
     * 编码
     */
    private String code;

    /**
     * 别名
     */
    private String alias;

    /**
     * 0:不是数组 1:数组
     */
    private String arrayType;

    /**
     * 类型
     */
    private String fieldType;

    /**
     * 字典id
     */
    private Long dictId;

    /**
     * 空标识
     */
    private String niKey;

    /**
     * 主键标识
     */
    private String fieldKey;

    /**
     * 缺省值
     */
    private String defaultValue;

    /**
     * 字段标题信息
     */
    private String title;

    /**
     * 字段说明信息
     */
    private String remark;

    /**
     * 字段提示信息
     */
    private String tips;

    /**
     * 显示位置
     */
    private Long sortPlace;

    /**
     * 索引名字
     */
    private String uniqueName;

    /**
     * 状态
     */
    private String status;

    /**
     * 创建用户
     */
    private Long createUser;

    /**
     * 创建用户中文名
     */
    private String createUserName;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 数据状态
     */
    private Long updateUser;

    /**
     * 更新用户中文名
     */
    private String updateUserName;

    /**
     * 更新时间
     */
    private LocalDateTime updateTime;

    /**
     * 删除标识
     */
    private String deleteFlag;

    /**
     * 公式/自增编号内容
     */
    private String formulaContent;

    /**
     * 返回类型
     */
    private String valueType;

    /**
     * 校验内容
     */
    private String validateContent;

    /**
     * 最小值-启始值
     */
    private String minValue;

    /**
     * 最大值
     */
    private String maxValue;

    /**
     * 条件信息
     */
    private String domainCondition;
}
