package com.xforceplus.ultraman.bocp.metadata.vo;

import lombok.Data;
import lombok.experimental.Accessors;

@Data
@Accessors(chain = true)
public class BoFieldVo {
    /**
     * 表id
     */
    private Long id;

    private Long uniqueId;
    /**
     * BoID
     */
    private Long boId;

    /**
     * 名称
     */
    private String name;

    /**
     * 别名
     */
    private String alias;

    /**
     * 编码
     */
    private String code;

    /**
     * 是不是数组
     */
    private Boolean isArray;

    /**
     * 类型
     */
    private String type;

    /**
     * 枚举类型对应的枚举id
     */
    private Long enumId;

    /**
     * 主键标识
     */
    private String fieldKey;

    /**
     * 缺省值
     */
    private String defaultValue;

    /**
     * 字段标题信息
     */
    private String title;

    /**
     * 字段说明信息
     */
    private String remark;

    /**
     * 字段提示信息
     */
    private String tips;

    /**
     * 显示位置
     */
    private Long sortPlace;

    /**
     * 删除标识
     */
    private String deleteFlag;

    /**
     * 字典CODE
     */
    private String enumCode;

    /**
     * 最大长度
     */
    private String maxLength;

    /**
     * 长度
     */
    private String length;

    /**
     * 小数点
     */
    private String decimalPoint;
    /**
     * 是否可编辑
     */
    private Boolean editable;

    /**
     * 是否可搜索
     */
    private Boolean searchable;

    /**
     * 是否为空
     */
    private Boolean required;

    /**
     * 是否唯一
     */
    private Boolean unique;
    /**
     * 描述字段
     */
    private String describeType;

    /**
     * 校验正则表达式
     */
    private String validateRule;

    /**
     * 是否锁定
     */
    private Boolean locked;

    /**
     * 关联ID-关联字段存在这个ID信息
     */
    private RelationVo relation;

    /**
     * 父类字段
     */
    private Boolean parentField;

    /**
     * 系统字段
     */
    private Boolean systemField;

    /**
     * 同步字段id
     */
    private Long syncFieldId;

    /**
     * 引用字段id
     */
    private Long refFieldId;

    /**
     * 固定ID
     */
    private Long publishFieldId;

    /**
     * 模糊类型
     */
    private String fuzzyType;

    /**
     * 通配符最小长度
     */
    private Integer wildcardMinWidth;

    /**
     * 通配符最大长度
     */
    private Integer wildcardMaxWidth;

    /**
     * 公式/自增编号内容
     */
    private String formulaContent;

    /**
     * 返回类型
     */
    private String valueType;

    /**
     * 校验内容
     */
    private String validateContent;

    /**
     * 最小值-启始值
     */
    private String minValue;

    /**
     * 最大值
     */
    private String maxValue;

    /**
     * 条件信息
     */
    private String domainCondition;

    /**
     * 字段领域配置信息JSON
     */
    private String domainConfig;

    /**
     * 递增类型0：严格递增1：趋势递增
     */
    private String noModel;

    /**
     * 步长
     */
    private Integer step;

    /**
     * 自增编号信息
     */
    private String domainNoContent;

    /**
     * 错误处理类型：1：抛异常 2：转默认值
     */
    private Integer failedPolicy;

    /**
     * 错误处理-默认值
     */
    private String failedDefaultValue;

    /**
     * 错误处理-引用对象ID-lookupEntityClassId
     */
    private Long lookupBoId;

    /**
     * 引用对象字段ID-lookupEntityFieldId
     */
    private Long lookupFieldId;

    /**
     * 查找字段关系信息id
     */
    private Long lookupRelationId;

    /**
     * 浮点值精度模式 1：四舍五入  2：截取
     */
    private String valueFloatScale;

    /**
     * 重置类型：0，重置，1不重置
     */
    private String resetType;

    /**
     * 自增编号复杂级别：0-简单，1-高级
     */
    private String domainNoSenior;

    /**
     * 聚合对象ID
     */
    private Long aggregationBoId;

    /**
     * 聚合对象字段ID
     */
    private Long aggregationFieldId;

    /**
     * 公式类型count-1;sum-2;avg-3;min-4;max-5
     */
    private String aggregationType;

    /**
     * 聚合字段关系信息id
     */
    private Long aggregationRelationId;

    /**
     * 前端ui配置信息
     */
    private String uiConfig;

    /**
     * 动态字段
     */
    private String dynamicType;

    /**
     * 动态字段
     */
    private Boolean dynamic;

    /**
     * 系统类型
     */
    private String sysType;

}
