package com.xforceplus.ultraman.bocp.metadata.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.bo.dto.BoApiInfoDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.List;
import java.util.Map;

/**
 * <p>
 * 业务对象查询结果
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-28
 */
@JsonIgnoreProperties({"tenantId"})
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BoInfoVo {

  public BoInfoVo(){
    fields = Lists.newArrayList();
    subEntities = Lists.newArrayList();
    toManyRelations = Lists.newArrayList();
    indexes = Lists.newArrayList();
  }

  /**
   * 业务对象ID
   */
  private Long id;
  /**
   * 业务对象编码
   */
  private String code;
  /**
   * 业务对象名称
   */
  private String name;

  private Long appId;

  /**
   *  租户代码
   */
  private String tenantCode;
  /**
   * 租户名称
   */
  private String tenantName;
  /**
   * 类型
   */
  private String boType;

  /**
   * 创建方式
   */
  private String createType;

  /**
   * 父对象Id
   */
  private Long parentBoId;

  /**
   * 系统类型
   */
  private String sysType;

  /**
   * 说明信息
   */
  private String remark;

  /**
   * 版本
   */
  private String version;
  /**
   * 根boId
   */
  private Long publishBoId;


  private String publishFlag;

  /**
   * 继承层级
   */
  private Integer level;

  /**
   * 业务对象Api信息
   */
//  private List<BoApi> api;
//  private Map<String, Map> api;
  private Map<String, BoApiInfoDTO> api;
  /**
   * 业务对象字段信息
   */
  private List<BoFieldVo> fields;
  /**
   * 子对象的ID集合
   */
  private List<RelationVo> toManyRelations;

  /**
   * 对象静态Api信息
   */
  private Map<String, Map> staticApi;

  /**
   * 对象索引
   */
  private List<BoIndexVo> indexes;
//  private BoIndexVo index;

  private List<BoSimpleVo> subEntities;

  /**
   * refboId
   */
  private Long refBoId;

  private String customType;

  //操作
  private String op;
  //复制操作-复制的对象ID
  private Long copyBoId;
}
