package com.xforceplus.ultraman.bocp.metadata.vo;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 枚举对象信息
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-28
 */
@JsonIgnoreProperties({"tenantId"})
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class DictVo {
    /**
     * 主键
     */
    private Long id;
    private Long uniqueId;
    /**
     * 应用ID
     */
    private Long appId;
    /**
     * 租户代码
     */
    private String tenantCode;
    /**
     *  租户名称
     */
    private String tenantName;
    /**
    /**
     * 名称
     */
    private String name;

    /**
     * 编码
     */
    private String code;

    /**
     * 版本
     */
    private String version;

    /**
     * 备注信息
     */
    private String remark;

    /**
     * 固定ID
     */
    private Long publishDictId;

    private String systemType;

    private Long refDictId;

    /**
     * 定制类型
     */
    private String customType;

    private Long updateUser;

    private String updateUserName;

    private LocalDateTime updateTime;

    private Long createUser;

    private String createUserName;

    private LocalDateTime createTime;

    private String appCustomType;
    private boolean customDisabled;

    /**
     * 字典详情
     */
    private List<DictDetailVo> options;

    public DictVo() {}

    public DictVo(Long id, String version) {
        this.id = id;
        this.version = version;
    }
}
