package com.xforceplus.ultraman.bocp.metadata.vo;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * <p>
 * 模块信息
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-28
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class ModuleInfoVo implements Serializable {

  private static final long serialVersionUID=1L;

    /**
     * 表id
     */
  private Long id;

  /**
   *
   */
  private Long appId;

    /**
     * 名称
     */
  private String name;

    /**
     * 编码
     */
  private String code;

    /**
     * 类型
     */
  private String moduleType;

    /**
     * 系统类型
     */
  private String sysType;

    /**
     * 说明信息
     */
  private String remark;

    /**
     * 版本
     */
  private String version;

    /**
     * 创建用户
     */
  private Long createUser;

    /**
     * 创建时间
     */
  private LocalDateTime createTime;

    /**
     * 更新用户
     */
  private Long updateUser;

    /**
     * 更新时间
     */
  private LocalDateTime updateTime;

    /**
     * 禁用状态
     */
  private String prohibitState;

    /**
     * 审核人
     */
  private Long reviewUser;

    /**
     * 审核时间
     */
  private LocalDateTime reviewTime;

    /**
     * 禁用人
     */
  private Long prohibitUser;

    /**
     * 禁用时间
     */
  private LocalDateTime prohibitTime;

    /**
     * 删除标识
     */
  private String deleteFlag;

  public ModuleInfoVo() {}

  public ModuleInfoVo(Long id, String version, String remark) {
    this.id = id;
    this.version = version;
    this.remark = remark;
  }
}
