package com.xforceplus.ultraman.bocp.metadata.vo.external;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.xforceplus.ultraman.bocp.metadata.bo.dto.BoApiInfoDTO;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoIndexVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoSimpleVo;
import com.xforceplus.ultraman.bocp.metadata.vo.RelationVo;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * <p>
 * 业务对象外部结构
 * </p>
 *
 * @author wangzheng
 * @since 2019-11-28
 */
@JsonIgnoreProperties({"tenantId"})
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BoInfoExt implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 业务对象ID
     */
    private Long id;
    /**
     * 业务对象编码
     */
    private String code;
    /**
     * 业务对象名称
     */
    private String name;
    /**
     *  租户代码
     */
    private String tenantCode;
    /**
     * 租户名称
     */
    private String tenantName;
    /**
     * 类型
     */
    private String boType;

    /**
     * 创建方式
     */
    private String createType;

    /**
     * 父对象Id
     */
    private Long parentBoId;
    /**
     * 说明信息
     */
    private String remark;
    /**
     * 版本
     */
    private String version;
    /**
     * 业务对象Api信息
     */
    private HashMap<String, BoApiInfoDTO> api;
    /**
     * 业务对象字段信息
     */
    private List<BoFieldVo> fields;
    /**
     * 子对象的ID集合
     */
    private List<RelationVo> toManyRelations;

    /**
     * 对象静态Api信息
     */
    private HashMap<String, Map> staticApi;
    /**
     * 对象索引
     */
    private List<BoIndexVo> indexes;

    private List<BoSimpleVo> subEntities;

}
