package com.xforceplus.ultraman.bocp.gen.autodb.db.mysql;

import org.apache.commons.lang.StringUtils;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.xforceplus.ultraman.bocp.gen.autodb.db.TableActuator;
import com.xforceplus.ultraman.bocp.gen.autodb.po.BoInfo;

import java.sql.*;
import java.util.ArrayList;
import java.util.List;

public class MysqlTableActuator implements TableActuator {

    /**
     * SQL连接
     */
    private Connection connection;
    /**
     * SQL语句类型
     */
    private IDbQuery dbQuery;
    /**
     * 数据库表信息
     */
    private List<BoInfo> boInfos;

    /**
     * 获取数据库中所有表的信息
     * @param dataSourceConfig
     * @return
     */
    @Override
    public List<BoInfo>  getTables(DataSourceConfig dataSourceConfig){
        boInfos = new ArrayList<BoInfo>();
        connection = dataSourceConfig.getConn();
        dbQuery = dataSourceConfig.getDbQuery();
        String tablesSql = dbQuery.tablesSql();
        try (PreparedStatement preparedStatement = connection.prepareStatement(tablesSql)) {
            ResultSet results = preparedStatement.executeQuery();
            while (results.next()) {
                String tableName = results.getString(dbQuery.tableName());
                if (StringUtils.isNotEmpty(tableName)) {
                    BoInfo boInfo = new BoInfo();
                    boInfo.setName(tableName);
                    System.out.println(tableName);
                    String tableComment = results.getString(dbQuery.tableComment());
                    if(null!=tableComment){
                        boInfo.setRemark(tableComment);
                    }
                    boInfos.add(boInfo);
                } else {
                    System.err.println("当前数据库为空！！！");
                }
            }

        } catch (SQLException e) {
            e.printStackTrace();
        }
        return boInfos;
    }

    @Override
    public List<BoInfo> excuteTables(DataSourceConfig dataSourceConfig, String sqls) {
        boInfos = new ArrayList<BoInfo>();
        connection = dataSourceConfig.getConn();
        dbQuery = dataSourceConfig.getDbQuery();
        if (null == sqls){
            return null;
        }
        sqls.replaceAll("\n","");
        String[] sqlarr = sqls.split(";");
        try {
            Statement statement = connection.createStatement();
            for (String s : sqlarr) {
                statement.addBatch(s);
            }
            int[] sqli = statement.executeBatch();
            for (int i = 0; i < sqli.length; i++) {
                if (sqli[i] == 0) {
                    System.out.println("执行成功，影响数据数量：" + sqli[i] + ";SQL信息" + sqlarr[i]);
                }else if(sqli[i] > 0){
                    System.out.println("执行成功，影响数据数量：" + sqli[i] + ";SQL信息" + sqlarr[i]);
                }else {
                    System.out.println("执行失败" + ";SQL信息" + sqlarr[i]);
                }
            }
            System.out.println(sqli[0]);
        } catch (SQLException e) {
            e.printStackTrace();
        }
        return boInfos;
    }

    public static void main(String[] args) {
        // 数据源配置
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl("jdbc:mysql://localhost:3306/bill?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
        // dsc.setSchemaName("public");
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("FGlai123");
        MysqlTableActuator mysqlTableActuator = new MysqlTableActuator();
        List<BoInfo> boInfos1 = mysqlTableActuator.getTables(dsc);
        System.out.println(boInfos1.size());
        String sql = "drop table if exists User;\n" +
                "create table User(\n" +
                "id bigint not null primary key comment 'ID',\n" +
                "name varchar(256) not null comment '用户名',\n" +
                "create_date datetime comment '创建时间'\n" +
                ");\n" +
                "alter table User comment '用户信息表';";
        List<BoInfo> boInfos = mysqlTableActuator.excuteTables(dsc,sql);

    }
}
