package com.xforceplus.ultraman.bocp.gen.autodb.file;

import com.baomidou.mybatisplus.generator.config.ConstVal;
import com.baomidou.mybatisplus.generator.config.rules.FileType;

import java.io.*;

public class SqlFile {
    /**
     * 将SQL保存至本地
     */
    public static void saveLocalSqlFile(String sql,String outputFile) throws Exception {
        try(FileOutputStream fos = new FileOutputStream(outputFile)){
            OutputStreamWriter ow = new OutputStreamWriter(fos, ConstVal.UTF8);
            BufferedWriter writer = new BufferedWriter(ow);
            writer.write(sql);
            writer.flush();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 检测文件是否存在
     *
     * @return 文件是否存在
     */
    protected static boolean isCreate(String filePath) {
        // 全局判断【默认】
        File file = new File(filePath);
        boolean exist = file.exists();
        if (!exist) {
            file.getParentFile().mkdirs();
        }
        return !exist;
    }
}
