package com.xforceplus.ultraman.bocp.gen.autodb.po;

import lombok.Data;

@Data
public class AddColumn {
    /**
     * Name of the column
     */
    private String name;
    /**
     * Column data type
     */
    private String type;
    /**
     * Value to set the column to
     */
    private String value;
    /**
     * length-type
     */
    private Integer length;
    /**
     * 字段是否为空标识
     */
    private String nullKey;
    /**
     * 字段主键标识
     */
    private String fieldKey;
    /**
     * Used if the value in "name" isn't actually a column name but actually a function. Since 3.3.2
     */
    private String computed;
    /**
     * Numeric value to set the column to
     */
    private String valueNumeric;
    /**
     * Boolean value to set the column to.
     */
    private String valueBoolean;
    /**
     * Date and/or Time value to set the column to. The value is specified in one of the following forms:
     * "YYYY-MM-DD", "hh:mm:ss" or "YYYY-MM-DDThh:mm:ss".
     */
    private String valueDate;
    /**
     * A value that is returned from a function or procedure call.
     */
    private String valueComputed;
    /**
     * Path to a file, whose contents will be written as a BLOB (i.e. chunk of binary data)
     *  (absolute paths are, e.g.: /usr/local/somefile.dat on Unix or c:\Directory\somefile.
     *  dat on Windows. Please refer to java.io.File javadoc for the details of what to consider relative/absolute path).
     */
    private String valueBlobFile;
    /**
     * Path to a file, whose contents will be written as a CLOB (i.e. chunk of character data).
     *  (absolute paths are, e.g.: /usr/local/somefile.dat on Unix or c:\Directory\somefile.dat on Windows.
     *  Please refer to java.io.File javadoc for the details of what to consider relative/absolute path).
     */
    private String valueClobFile;
    /**
     * Name of the encoding (as specified in java.nio.Charset javadoc, e.g. "UTF-8")
     */
    private String encoding;
    /**
     * Default value for column.
     */
    private String defaultValue;
    /**
     * Default numeric value for column
     */
    private String defaultValueNumeric;
    /**
     * Default boolean value for column
     */
    private String defaultValueBoolean;
    /**
     * Default date and/or time value for column. The value is specified in one of the
     * following forms: "YYYY-MM-DD", "hh:mm:ss" or "YYYY-MM-DDThh:mm:ss"
     */
    private String defaultValueDate;
    /**
     * A value that is returned from a function or procedure call.
     */
    private String defaultValueComputed;
    /**
     * Is column an auto-increment column.
     */
    private String autoIncrement;
    /**
     * The value auto-increment start.
     */
    private String startWith;
    /**
     * The value of each step by auto-increment.
     */
    private String incrementBy;
    /**
     * Short description of the column (column comment)
     */
    private String remarks;
    /**
     * If used in an 'addColumn' command, this attribute allows you to control where in the table column
     * order the new column goes. Only one of beforeColumn, afterColumn or position are allowed. Since 3.1
     */
    private String beforeColumn;
    /**
     *If used in an 'addColumn' command, this attribute allows you to control where in the table column order
     * the new column goes
     */
    private String afterColumn;
    /**
     *If used in an 'addColumn' command, this attribute allows you to control where in the table column order
     * the new column goes.
     */
    private String position;
    /**
     *If used in a 'createIndex' command, this boolean attribute allows you to specify that a column should
     * be used in descending order in the index.
     */
    private String descending;

}
