package com.xforceplus.ultraman.bocp.gen.autodb.po;

import lombok.Data;

/**
 * 约束对象 - 目前不深入使用
 */
@Data
public class Constraints {
    /**
     * Is column nullable列可以为空吗？
     */
    private boolean nullable;
    /**
     * Is column a primary key?列是主键吗？
     */
    private boolean primaryKey;
    /**
     * Primary key name Since 1.6自1.6起的主键名称
     */
    private String primaryKeyName;
    /**
     * Should a unique clause be applied是否应使用唯一条款
     */
    private boolean unique;
    /**
     * Unique constraint name唯一约束名称
     */
    private String uniqueConstraintName;
    /**
     * Foreign key definition外键定义
     */
    private String references;
    /**
     * Foreign key name外键名称
     */
    private String foreignKeyName;
    /**
     * Set delete cascade设置删除级联
     */
    private boolean deleteCascade;
    /**
     * Are constraints deferrable约束是否可延期
     */
    private boolean deferrable;
    /**
     * 	Are constraints deferrable最初是否推迟了约束
     */
    private boolean initiallyDeferred;
}
