package com.xforceplus.ultraman.bocp.gen.autodb.schema;

import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.xforceplus.ultraman.bocp.gen.autodb.config.BoConfig;
import com.xforceplus.ultraman.bocp.gen.autodb.file.SqlFile;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.SqlAssembly;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.create.CreateModel;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.mysql.MysqlSqlAssembly;
import org.springframework.beans.factory.annotation.Autowired;

public class BocpDbSchema implements DbSchema {
    @Autowired
    private SqlAssembly sqlAssembly;

    @Override
    public void initBos(BoConfig boConfig, DataSourceConfig dataSourceConfig) throws Exception {
        //1、init sql
        CreateModel createModel = new CreateModel();
        createModel.setBoInfoList(boConfig.getBoInfoList());
        createModel.setDeleteCf(null == boConfig.getDeleteCf() ? false : boConfig.getDeleteCf());
        createModel.setDropCf(null == boConfig.getDropCf() ? false : boConfig.getDropCf());
        sqlAssembly = new MysqlSqlAssembly();
        String sql = sqlAssembly.createTable(createModel);
        //2、init db
//        TableActuator tableActuator = new MysqlTableActuator();
//        tableActuator.excuteTables(dataSourceConfig,sql);
        //3、init file
        SqlFile.saveLocalSqlFile(sql, "D://v1__init.sql");
    }

    @Override
    public String updateBos(BoConfig boConfig, DataSourceConfig dataSourceConfig) {
        return null;
    }
}
