package com.xforceplus.ultraman.bocp.gen.autodb.sql;

import com.xforceplus.ultraman.bocp.gen.autodb.po.BoInfo;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.create.CreateModel;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.update.UpdateModel;

import java.util.List;

/**
 * SQL动态拼装类
 */
public interface SqlAssembly{

    /**
     * 根据bo对象信息返回创建SQL语句
     * @param createModel
     * @return
     */
    public String createTable(CreateModel createModel);

    /**
     * 根据table对象信息返回更新SQL语句
     * @param updateModel
     * @return
     */
    public String updateTable(UpdateModel updateModel);

    /**
     * 根据新旧对象列表信息返回差异SQL
     * @param boInfos
     * @param oldBoInfos
     * @return
     */
    public Boolean checkTable(List<BoInfo> boInfos, List<BoInfo> oldBoInfos);


}
