package com.xforceplus.ultraman.bocp.gen.autodb.sql.create;

import org.apache.commons.lang.StringUtils;
import com.xforceplus.ultraman.bocp.gen.autodb.po.BoField;
import com.xforceplus.ultraman.bocp.gen.autodb.po.BoInfo;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.mysql.MysqlGenUtil;

import java.util.List;

public class CreateDSL {

    /**
     * 返回创建SQL
     *
     * @param createModel
     * @return
     */
    public static String create(CreateModel createModel) {
        StringBuffer sql = new StringBuffer();
        if (createModel == null) {
            return null;
        }
        if (createModel.getBoInfoList() != null) {
            List<BoInfo> boInfos = createModel.getBoInfoList();
            for (BoInfo bo : boInfos) {
                //是否要删除表结构和数据的判断
                if (createModel.getDropCf() != null && createModel.getDropCf()) {
                    sql.append(CreateVal.DROP + CreateVal.BLANK_SPACE + bo.getName() + CreateVal.END_SYMBOL);
                    sql.append(CreateVal.CHANGE_LINE);
                }
                if (createModel.getDeleteCf() != null && createModel.getDeleteCf()) {
                    sql.append(CreateVal.DELETE + CreateVal.BLANK_SPACE + bo.getName() + CreateVal.END_SYMBOL);
                    sql.append(CreateVal.CHANGE_LINE);
                }
                //创建表语句
                sql.append(CreateVal.CREATE + CreateVal.BLANK_SPACE + bo.getName() + CreateVal.BLANK_SPACE + CreateVal.LEF_PARENT);
                sql.append(CreateVal.CHANGE_LINE);
                List<BoField> fields = bo.getBoFieldList();
                //字段为空的时候设置个id默认字段
                if (fields == null) {
                    sql.append(CreateVal.ID + CreateVal.BLANK_SPACE + CreateVal.TYPE_INT + CreateVal.BLANK_SPACE +
                            CreateVal.NOT_NULL + CreateVal.BLANK_SPACE + CreateVal.COMMENT + CreateVal.BLANK_SPACE +
                            CreateVal.SINGLE_SYMBOL + CreateVal.ID + CreateVal.SINGLE_SYMBOL + CreateVal.COMMA_SYMBOL);
                    sql.append(CreateVal.PRIMARY_KEY + CreateVal.BLANK_SPACE + CreateVal.LEF_PARENT + CreateVal.ID + CreateVal.RIGHT_PARENT);
                    sql.append(CreateVal.RIGHT_PARENT);
                    sql.append(CreateVal.CHANGE_LINE);
                    sql.append(CreateVal.ALTER + CreateVal.BLANK_SPACE + bo.getName() + CreateVal.BLANK_SPACE +
                            CreateVal.COMMENT + CreateVal.BLANK_SPACE + CreateVal.SINGLE_SYMBOL + bo.getRemark() +
                            CreateVal.SINGLE_SYMBOL + CreateVal.END_SYMBOL);
                    sql.append(CreateVal.CHANGE_LINE);
                    break;
                }
                //处理字段信息
                for (BoField field : fields) {
                    sql.append(CreateVal.BLANK_SPACE + CreateVal.BLANK_SPACE + field.getName() + CreateVal.BLANK_SPACE);
                    sql.append(MysqlGenUtil.convertToMysqlColumnType(field));
                    if (!StringUtils.isEmpty(field.getNullKey())) {
                        sql.append(CreateVal.NOT_NULL + CreateVal.BLANK_SPACE);
                    }
                    if ("1".equals(field.getFieldKey())) {
                        sql.append(CreateVal.PRIMARY_KEY + CreateVal.BLANK_SPACE);
                    }
                    if (!StringUtils.isEmpty(field.getRemark())) {
                        sql.append(CreateVal.COMMENT + CreateVal.BLANK_SPACE + CreateVal.SINGLE_SYMBOL +
                                field.getRemark() + CreateVal.SINGLE_SYMBOL);
                    }
                    boolean last = field.getName() == fields.get(fields.size() - 1).getName() ? true : false;
                    if (!last) {
                        sql.append(CreateVal.COMMA_SYMBOL);
                    }
                    sql.append(CreateVal.CHANGE_LINE);
                }
                sql.append(CreateVal.RIGHT_PARENT + CreateVal.END_SYMBOL);
                sql.append(CreateVal.CHANGE_LINE);
                sql.append(CreateVal.ALTER + CreateVal.BLANK_SPACE + bo.getName() + CreateVal.BLANK_SPACE +
                        CreateVal.COMMENT + CreateVal.BLANK_SPACE + CreateVal.SINGLE_SYMBOL + bo.getRemark() +
                        CreateVal.SINGLE_SYMBOL + CreateVal.END_SYMBOL);
                sql.append(CreateVal.CHANGE_LINE);
            }
        }
        return sql.toString();
    }

}
