package com.xforceplus.ultraman.bocp.gen.autodb.sql.mysql;

import com.xforceplus.ultraman.bocp.gen.autodb.po.BoField;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.create.CreateVal;

public class MysqlGenUtil {

    public static String convertToMysqlColumnType(BoField field){
        String mysqlFieldType;
        switch (field.getFieldType()) {
            case CreateVal.INT:
                mysqlFieldType = convertToMysqlIntType(field.getLength());
                break;
            case CreateVal.DATETIME:
                mysqlFieldType = CreateVal.TYPE_DATE;
                break;
            case CreateVal.DECIMAL:
                mysqlFieldType = convertToMysqlDecimalType(field.getLength(), field.getDecimalPoint());
                break;
            case CreateVal.BOOLEAN:
                mysqlFieldType = CreateVal.TYPE_BOOL;
                break;
            case CreateVal.TEXT:
                mysqlFieldType = CreateVal.TYPE_TEXT;
                break;
            case CreateVal.MEDIUM_TEXT:
                mysqlFieldType = CreateVal.TYPE_MTEXT;
                break;
            case CreateVal.LONG_TEXT:
                mysqlFieldType = CreateVal.TYPE_LTEXT;
                break;
            case CreateVal.JSON:
                mysqlFieldType = CreateVal.TYPE_JSON;
                break;
            case CreateVal.STRING:
            default:
                mysqlFieldType = convertToMysqlStringType(field.getLength());
        }
        return mysqlFieldType + CreateVal.BLANK_SPACE;
    }

    public static String convertToMysqlIntType(Integer length) {
        return CreateVal.TYPE_INT + CreateVal.LEF_PARENT + (null != length ? length : 255)
                + CreateVal.RIGHT_PARENT;
    }

    public static String convertToMysqlStringType(Integer length) {
        return CreateVal.TYPE_STRING + CreateVal.LEF_PARENT + (null != length ? length : 255)
                + CreateVal.RIGHT_PARENT + CreateVal.BLANK_SPACE
                + "CHARACTER SET utf8";
    }

    public static String convertToMysqlDecimalType(Integer length, Integer decimalPoint) {
        return CreateVal.TYPE_DECIMAL + CreateVal.LEF_PARENT + length
                + CreateVal.COMMA_SYMBOL + CreateVal.BLANK_SPACE + decimalPoint
                + CreateVal.RIGHT_PARENT;
    }
}
