package com.xforceplus.ultraman.bocp.gen.autodb.sql.update;


import com.xforceplus.ultraman.bocp.gen.autodb.po.AddColumn;
import com.xforceplus.ultraman.bocp.gen.autodb.po.ChangeInfo;
import com.xforceplus.ultraman.bocp.gen.autodb.po.ChangeSet;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.create.CreateVal;

import java.util.List;

public class UpdateDSL {

    /**
     * 返回更新SQL
     *
     * @param updateModel
     * @return
     */
    public static String update(UpdateModel updateModel) {
        StringBuffer sql = new StringBuffer();
        if (updateModel == null) {
            return null;
        }
        if (updateModel.getChangeInfos() != null) {
            List<ChangeInfo> changeInfos = updateModel.getChangeInfos();
            sql.append(updateTable(changeInfos));
        }
        return sql.toString();
    }

    /**
     * table更新方法
     *
     * @param changeInfos
     * @return
     */
    public static String updateTable(List<ChangeInfo> changeInfos) {
        StringBuffer sql = new StringBuffer();
        for (ChangeInfo changeInfo : changeInfos) {
            List<ChangeSet> changeSets = changeInfo.getChangeSets();
            for (ChangeSet changeSet : changeSets) {
                sql.append(UpdateVal.ALTER + UpdateVal.BLANK_SPACE + changeSet.getTableName() + UpdateVal.BLANK_SPACE);
                sql.append(CreateVal.CHANGE_LINE);
                switch (changeSet.getChangeType()) {
                    case UpdateVal.CHANGE_TYPE_ADD:
                        sql.append(addColoum(changeSet.getAddColumns()));
                        break;
                    default:
                        addColoum(changeSet.getAddColumns());
                        break;

                }
                sql.append(CreateVal.END_SYMBOL);
            }
        }
        return sql.toString();
    }

    /**
     * 字段更新方法 - 暂不提供
     *
     * @param addColumns
     * @return
     */
    public static String updateColoum(List<AddColumn> addColumns) {
        StringBuffer sql = new StringBuffer();

        return sql.toString();
    }

    /**
     * 新增字段方法
     *
     * @param addColumns
     * @return
     */
    public static String addColoum(List<AddColumn> addColumns) {
        StringBuffer sql = new StringBuffer();
        if (null != addColumns) {
            for (AddColumn addColumn : addColumns) {
                sql.append(UpdateVal.ADD_COLUMN + UpdateVal.BLANK_SPACE);
                sql.append(addColumn.getName() + UpdateVal.BLANK_SPACE);
                switch (addColumn.getType()) {
                    case UpdateVal.STRING:
                        sql.append(UpdateVal.TYPE_STRING + UpdateVal.LEF_PARENT + (null != addColumn.getLength() ? addColumn.getLength() : 256) +
                                UpdateVal.RIGHT_PARENT + UpdateVal.BLANK_SPACE);
                        break;
                    case UpdateVal.INT:
                        sql.append(UpdateVal.TYPE_INT + UpdateVal.BLANK_SPACE);
                        break;
                    case UpdateVal.DATETIME:
                        sql.append(UpdateVal.TYPE_DATA + UpdateVal.BLANK_SPACE);
                        break;
                    default:
                        sql.append(UpdateVal.TYPE_STRING + UpdateVal.LEF_PARENT + (null != addColumn.getLength() ? addColumn.getLength() : 256) +
                                UpdateVal.RIGHT_PARENT + UpdateVal.BLANK_SPACE);
                        break;
                }
                ;
                if (addColumn.getNullKey() != null) {
                    sql.append(CreateVal.NOT_NULL + CreateVal.BLANK_SPACE);
                }
                if (addColumn.getFieldKey() != null) {
                    sql.append(CreateVal.PRIMARY_KEY + CreateVal.BLANK_SPACE);
                }
                if (addColumn.getRemarks() != null) {
                    sql.append(CreateVal.COMMENT + CreateVal.BLANK_SPACE + CreateVal.SINGLE_SYMBOL +
                            addColumn.getRemarks() + CreateVal.SINGLE_SYMBOL);
                }
                boolean last = addColumn.getName() == addColumns.get(addColumns.size() - 1).getName() ? true : false;
                if (!last) {
                    sql.append(CreateVal.COMMA_SYMBOL);
                }
                sql.append(CreateVal.CHANGE_LINE);

            }
        }
        return sql.toString();
    }

    /**
     * 删除相关的方法
     *
     * @param updateModel
     * @return
     */
    public static String delete(UpdateModel updateModel) {
        StringBuffer sql = new StringBuffer();

        return sql.toString();
    }
}
