/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.autodb.db.mysql;

import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.xforceplus.ultraman.bocp.gen.autodb.db.TableActuator;
import com.xforceplus.ultraman.bocp.gen.autodb.po.BoInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class MysqlTableActuator
implements TableActuator {
    private Connection connection;
    private IDbQuery dbQuery;
    private List<BoInfo> boInfos;

    @Override
    public List<BoInfo> getTables(DataSourceConfig dataSourceConfig) {
        this.boInfos = new ArrayList<BoInfo>();
        this.connection = dataSourceConfig.getConn();
        this.dbQuery = dataSourceConfig.getDbQuery();
        String tablesSql = this.dbQuery.tablesSql();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(tablesSql);){
            ResultSet results = preparedStatement.executeQuery();
            while (results.next()) {
                String tableName = results.getString(this.dbQuery.tableName());
                if (StringUtils.isNotEmpty((String)tableName)) {
                    BoInfo boInfo = new BoInfo();
                    boInfo.setName(tableName);
                    System.out.println(tableName);
                    String tableComment = results.getString(this.dbQuery.tableComment());
                    if (null != tableComment) {
                        boInfo.setRemark(tableComment);
                    }
                    this.boInfos.add(boInfo);
                    continue;
                }
                System.err.println("\u5f53\u524d\u6570\u636e\u5e93\u4e3a\u7a7a\uff01\uff01\uff01");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.boInfos;
    }

    @Override
    public List<BoInfo> excuteTables(DataSourceConfig dataSourceConfig, String sqls) {
        this.boInfos = new ArrayList<BoInfo>();
        this.connection = dataSourceConfig.getConn();
        this.dbQuery = dataSourceConfig.getDbQuery();
        if (null == sqls) {
            return null;
        }
        sqls.replaceAll("\n", "");
        String[] sqlarr = sqls.split(";");
        try {
            Statement statement = this.connection.createStatement();
            for (String s : sqlarr) {
                statement.addBatch(s);
            }
            int[] sqli = statement.executeBatch();
            for (int i = 0; i < sqli.length; ++i) {
                if (sqli[i] == 0) {
                    System.out.println("\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u6570\u636e\u6570\u91cf\uff1a" + sqli[i] + ";SQL\u4fe1\u606f" + sqlarr[i]);
                    continue;
                }
                if (sqli[i] > 0) {
                    System.out.println("\u6267\u884c\u6210\u529f\uff0c\u5f71\u54cd\u6570\u636e\u6570\u91cf\uff1a" + sqli[i] + ";SQL\u4fe1\u606f" + sqlarr[i]);
                    continue;
                }
                System.out.println("\u6267\u884c\u5931\u8d25;SQL\u4fe1\u606f" + sqlarr[i]);
            }
            System.out.println(sqli[0]);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.boInfos;
    }

    public static void main(String[] args) {
        DataSourceConfig dsc = new DataSourceConfig();
        dsc.setUrl("jdbc:mysql://localhost:3306/bill?useUnicode=true&serverTimezone=GMT&useSSL=false&characterEncoding=utf8");
        dsc.setDriverName("com.mysql.jdbc.Driver");
        dsc.setUsername("root");
        dsc.setPassword("FGlai123");
        MysqlTableActuator mysqlTableActuator = new MysqlTableActuator();
        List<BoInfo> boInfos1 = mysqlTableActuator.getTables(dsc);
        System.out.println(boInfos1.size());
        String sql = "drop table if exists User;\ncreate table User(\nid bigint not null primary key comment 'ID',\nname varchar(256) not null comment '\u7528\u6237\u540d',\ncreate_date datetime comment '\u521b\u5efa\u65f6\u95f4'\n);\nalter table User comment '\u7528\u6237\u4fe1\u606f\u8868';";
        List<BoInfo> boInfos = mysqlTableActuator.excuteTables(dsc, sql);
    }
}

