/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.autodb.solution;

import com.xforceplus.ultraman.bocp.gen.autodb.solution.DdlContext;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.DdlOpEnum;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.FieldAttrMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.FieldMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.IndexMeta;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.SqlGenerator;
import com.xforceplus.ultraman.bocp.gen.autodb.solution.TableMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.util.StringUtils;

public class MysqlSqlGenerator
implements SqlGenerator {
    private final DdlContext ddlContext;
    private final List<String> NUMERIC_FIELD_TYPES = new ArrayList<String>(Arrays.asList("int", "decimal"));
    private final List<String> TEXT_FIELD_TYPES = new ArrayList<String>(Arrays.asList("text", "mediumtext", "longtext", "json"));
    private final String SYS_DYNAMIC_FIELD_CODE = "_sys_dynamic";
    private TableMeta tableMeta;
    private IndexMeta indexMeta;
    private FieldMeta fieldMeta;
    private DdlOpEnum ddlOp;
    private ObjectType type;

    public MysqlSqlGenerator() {
        this.ddlContext = new DdlContext();
    }

    public MysqlSqlGenerator(DdlContext ddlContext) {
        this.ddlContext = ddlContext;
    }

    @Override
    public SqlGenerator table(TableMeta tableMeta, DdlOpEnum ddlOpEnum) {
        this.tableMeta = tableMeta;
        this.ddlOp = ddlOpEnum;
        this.type = ObjectType.TABLE;
        return this;
    }

    @Override
    public SqlGenerator index(IndexMeta indexMeta, DdlOpEnum ddlOpEnum) {
        this.indexMeta = indexMeta;
        this.ddlOp = ddlOpEnum;
        this.type = ObjectType.INDEX;
        return this;
    }

    @Override
    public SqlGenerator field(FieldMeta fieldMeta, DdlOpEnum ddlOpEnum) {
        this.fieldMeta = fieldMeta;
        this.ddlOp = ddlOpEnum;
        this.type = ObjectType.FIELD;
        return this;
    }

    @Override
    public SqlGenerator view(TableMeta tableMeta, DdlOpEnum ddlOpEnum) {
        this.tableMeta = tableMeta;
        this.ddlOp = ddlOpEnum;
        this.type = ObjectType.VIEW;
        return this;
    }

    @Override
    public String getSql() {
        return this.generateSql(false);
    }

    @Override
    public String getRSql() {
        return this.generateSql(true);
    }

    private String generateSql(boolean reverse) {
        this.check();
        if (ObjectType.TABLE.equals((Object)this.type)) {
            if (this.tableMeta == null) {
                throw new RuntimeException("table meta must not be null");
            }
            switch (this.ddlOp) {
                case CREATE: 
                case REMOVE: {
                    return reverse ? this.generateCreateOrRemoveTable(this.ddlOp.equals((Object)DdlOpEnum.CREATE) ? DdlOpEnum.REMOVE : DdlOpEnum.CREATE) : this.generateCreateOrRemoveTable(this.ddlOp);
                }
                case MODIFY: {
                    return this.genModifyTable(reverse);
                }
            }
        } else if (ObjectType.INDEX.equals((Object)this.type)) {
            if (this.indexMeta == null) {
                throw new RuntimeException("index meta must not be null");
            }
            switch (this.ddlOp) {
                case CREATE: 
                case REMOVE: {
                    return reverse ? this.generateCreateOrRemoveIndex(this.ddlOp.equals((Object)DdlOpEnum.CREATE) ? DdlOpEnum.REMOVE : DdlOpEnum.CREATE) : this.generateCreateOrRemoveIndex(this.ddlOp);
                }
                case MODIFY: {
                    return this.genModifyIndex(reverse);
                }
            }
        } else if (ObjectType.FIELD.equals((Object)this.type)) {
            if (this.fieldMeta == null) {
                throw new RuntimeException("field meta must not be null");
            }
            switch (this.ddlOp) {
                case CREATE: 
                case REMOVE: {
                    return reverse ? this.genCreateOrRemoveField(this.ddlOp.equals((Object)DdlOpEnum.CREATE) ? DdlOpEnum.REMOVE : DdlOpEnum.CREATE) : this.genCreateOrRemoveField(this.ddlOp);
                }
                case MODIFY: {
                    return this.genModifyField(reverse);
                }
            }
        } else if (ObjectType.VIEW.equals((Object)this.type)) {
            if (this.tableMeta == null) {
                throw new RuntimeException("view meta must not be null");
            }
            switch (this.ddlOp) {
                case CREATE: 
                case REMOVE: {
                    return reverse ? this.generateCreateOrRemoveView(this.ddlOp.equals((Object)DdlOpEnum.CREATE) ? DdlOpEnum.REMOVE : DdlOpEnum.CREATE) : this.generateCreateOrRemoveView(this.ddlOp);
                }
                case MODIFY: {
                    return this.genModifyView();
                }
            }
        }
        return null;
    }

    private String generateCreateOrRemoveTable(DdlOpEnum ddlOpEnum) {
        StringBuilder sql = new StringBuilder();
        if (DdlOpEnum.CREATE.equals((Object)ddlOpEnum)) {
            sql.append(String.format("CREATE TABLE `%s` ( \n", this.tableMeta.getCode()));
            if (this.tableMeta.getFieldMetas() != null) {
                List<FieldMeta> fields = this.tableMeta.getFieldMetas();
                for (FieldMeta field : fields) {
                    sql.append(String.format("  `%s` ", field.getCode()));
                    sql.append(this.convertToColumnType(field.getType(), field.getAttr()));
                    if (field.getAttr().isDynamic()) {
                        sql.append(String.format(" GENERATED ALWAYS AS (%s->>'$.%s') VIRTUAL", "_sys_dynamic", field.getCode()));
                    }
                    if (field.getAttr().isNotNull()) {
                        sql.append(" NOT NULL");
                    }
                    if (!field.getAttr().isDynamic()) {
                        sql.append(this.generateDefaultValue(field.getType(), field.getAttr()));
                    }
                    if (!StringUtils.isEmpty((Object)field.getAttr().getName())) {
                        sql.append(String.format(" COMMENT '%s'", field.getAttr().getName()));
                    }
                    sql.append(",");
                    sql.append("\n");
                }
            }
            sql.append("   PRIMARY KEY (`id`) \n");
            sql.append(String.format(") ENGINE = InnoDB DEFAULT CHARSET = %s COMMENT='%s';\n", this.ddlContext.getCharset(), this.tableMeta.getName()));
            if (this.tableMeta.getIndexMetas() != null) {
                Iterator<IndexMeta> iterator = this.tableMeta.getIndexMetas().iterator();
                while (iterator.hasNext()) {
                    IndexMeta indexMeta;
                    this.indexMeta = indexMeta = iterator.next();
                    sql.append(this.generateCreateOrRemoveIndex(ddlOpEnum));
                }
            }
        } else {
            sql.append(String.format("DROP TABLE `%s`; \n", this.tableMeta.getCode()));
        }
        return sql.toString();
    }

    private String genModifyTable(boolean reverse) {
        if (!reverse) {
            return String.format("ALTER TABLE `%s` COMMENT '%s'; \n", this.tableMeta.getCode(), this.tableMeta.getNewName());
        }
        return String.format("ALTER TABLE `%s` COMMENT '%s'; \n", this.tableMeta.getCode(), this.tableMeta.getName());
    }

    private String generateCreateOrRemoveIndex(DdlOpEnum ddlOpEnum) {
        StringBuilder sql = new StringBuilder();
        if (DdlOpEnum.CREATE.equals((Object)ddlOpEnum)) {
            String fieldCodeSql = this.getIndexFieldCodesSql(this.indexMeta.getFieldCodes());
            sql.append(String.format("CREATE %sINDEX `%s` on `%s` (%s); \n", "unique".equals(this.indexMeta.getType()) ? "UNIQUE " : "", this.indexMeta.getCode(), this.indexMeta.getTableCode(), fieldCodeSql));
        } else {
            sql.append(String.format("DROP INDEX `%s` on `%s`; \n", this.indexMeta.getCode(), this.indexMeta.getTableCode()));
        }
        return sql.toString();
    }

    private String genModifyIndex(boolean reverse) {
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("DROP INDEX `%s` on `%s`; \n", this.indexMeta.getCode(), this.indexMeta.getTableCode()));
        String fieldCodeSql = this.getIndexFieldCodesSql(this.indexMeta.getNewFieldCodes());
        sql.append(String.format("CREATE %sINDEX `%s` on `%s` (%s) \n", "unique".equals(this.indexMeta.getNewType()) ? "UNIQUE " : "", this.indexMeta.getCode(), this.indexMeta.getTableCode(), reverse ? this.indexMeta.getFieldCodes() : fieldCodeSql));
        return sql.toString();
    }

    private String genCreateOrRemoveField(DdlOpEnum ddlOpEnum) {
        if (this.fieldMeta.getAttr().isDynamic()) {
            return this.genCreateOrRemoveDynamicField(ddlOpEnum);
        }
        if (DdlOpEnum.CREATE.equals((Object)ddlOpEnum)) {
            StringBuilder sql = new StringBuilder();
            sql.append(String.format("ALTER TABLE `%s` ADD COLUMN `%s` ", this.fieldMeta.getTableCode(), this.fieldMeta.getCode()));
            sql.append(this.convertToColumnType(this.fieldMeta.getType(), this.fieldMeta.getAttr()));
            if (this.fieldMeta.getAttr().isNotNull()) {
                sql.append(" NOT NULL");
            }
            sql.append(this.generateDefaultValue(this.fieldMeta.getType(), this.fieldMeta.getAttr()));
            if (!StringUtils.isEmpty((Object)this.fieldMeta.getAttr().getName())) {
                sql.append(String.format(" COMMENT '%s'", this.fieldMeta.getAttr().getName()));
            }
            sql.append(";");
            sql.append("\n");
            return sql.toString();
        }
        return String.format(String.format("ALTER TABLE `%s` DROP COLUMN `%s`; \n", this.fieldMeta.getTableCode(), this.fieldMeta.getCode()), new Object[0]);
    }

    private String genModifyField(boolean reverse) {
        if (this.fieldMeta.getAttr().isDynamic()) {
            return this.genModifyDynamicField(reverse);
        }
        if (this.fieldMeta.getAttr() == null || this.fieldMeta.getOriginAttr() == null) {
            throw new RuntimeException("field attr or origin attr is null");
        }
        FieldAttrMeta fieldAttr = reverse ? this.fieldMeta.getOriginAttr() : this.fieldMeta.getAttr();
        StringBuilder sql = new StringBuilder();
        sql.append(String.format("ALTER TABLE `%s` MODIFY COLUMN `%s` ", this.fieldMeta.getTableCode(), this.fieldMeta.getCode()));
        sql.append(this.convertToColumnType(this.fieldMeta.getType(), fieldAttr));
        if (fieldAttr.isNotNull()) {
            sql.append(" NOT NULL");
        }
        sql.append(this.generateDefaultValue(this.fieldMeta.getType(), fieldAttr));
        if (!StringUtils.isEmpty((Object)fieldAttr.getName())) {
            sql.append(String.format(" COMMENT '%s'", fieldAttr.getName()));
        }
        sql.append(";");
        sql.append("\n");
        return sql.toString();
    }

    private String genCreateOrRemoveDynamicField(DdlOpEnum ddlOpEnum) {
        if (DdlOpEnum.CREATE.equals((Object)ddlOpEnum)) {
            StringBuilder sql = new StringBuilder();
            sql.append(String.format("ALTER TABLE `%s` ADD COLUMN `%s` ", this.fieldMeta.getTableCode(), this.fieldMeta.getCode()));
            sql.append(this.convertToColumnType(this.fieldMeta.getType(), this.fieldMeta.getAttr()));
            sql.append(String.format(" GENERATED ALWAYS AS (%s->>'$.%s') VIRTUAL", "_sys_dynamic", this.fieldMeta.getCode()));
            if (this.fieldMeta.getAttr().isNotNull()) {
                sql.append(" NOT NULL");
            }
            sql.append(this.generateDefaultValue(this.fieldMeta.getType(), this.fieldMeta.getAttr()));
            if (!StringUtils.isEmpty((Object)this.fieldMeta.getAttr().getName())) {
                sql.append(String.format(" COMMENT '%s'", this.fieldMeta.getAttr().getName()));
            }
            sql.append(";");
            sql.append("\n");
            return sql.toString();
        }
        return String.format(String.format("ALTER TABLE `%s` DROP COLUMN `%s`; \n", this.fieldMeta.getTableCode(), this.fieldMeta.getCode()), new Object[0]);
    }

    private String genModifyDynamicField(boolean reverse) {
        if (this.fieldMeta.getAttr() == null || this.fieldMeta.getOriginAttr() == null) {
            throw new RuntimeException("field attr or origin attr is null");
        }
        FieldAttrMeta fieldAttr = reverse ? this.fieldMeta.getOriginAttr() : this.fieldMeta.getAttr();
        this.fieldMeta.setAttr(fieldAttr);
        StringBuilder sql = new StringBuilder();
        sql.append(this.genCreateOrRemoveDynamicField(DdlOpEnum.REMOVE));
        sql.append(this.genCreateOrRemoveDynamicField(DdlOpEnum.CREATE));
        return sql.toString();
    }

    private String generateCreateOrRemoveView(DdlOpEnum ddlOpEnum) {
        if (null == this.tableMeta.getParentTableMeta()) {
            return "";
        }
        if (DdlOpEnum.CREATE.equals((Object)ddlOpEnum)) {
            return this.createViewSql();
        }
        return String.format("DROP VIEW `%s_%s`; \n", this.tableMeta.getCode(), this.ddlContext.getViewAffix());
    }

    private String genModifyView() {
        return this.generateViewSql(DdlOpEnum.MODIFY);
    }

    private String createViewSql() {
        return this.generateViewSql(DdlOpEnum.CREATE);
    }

    private String generateViewSql(DdlOpEnum ddlOpEnum) {
        if (this.tableMeta.isTenantBo()) {
            return this.generateTenantBoViewSql(ddlOpEnum);
        }
        Stack<String> tableAliasStack = this.getTableAliasStack();
        if (null == this.tableMeta.getParentTableMeta()) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        Map<String, String> fieldCodeMap = this.tableMeta.getFieldMetas().stream().filter(fm -> !"_sys_dynamic".equals(fm.getCode())).collect(Collectors.toMap(FieldMeta::getCode, f -> String.format("`a`.`%s` AS `%s`", f.getCode(), f.getCode())));
        sql.append(String.format("%s VIEW `%s_%s` AS \n", ddlOpEnum.ddlOp(), this.tableMeta.getCode(), this.ddlContext.getViewAffix()));
        sql.append("SELECT ");
        sql.append(String.join((CharSequence)",", fieldCodeMap.values()));
        ArrayList<String> childFieldCodeList = new ArrayList<String>(fieldCodeMap.keySet());
        StringBuilder leftJoinSql = new StringBuilder();
        ArrayList<String> parentTableAliasUsed = new ArrayList<String>();
        for (TableMeta parentTableMeta = this.tableMeta.getParentTableMeta(); null != parentTableMeta; parentTableMeta = parentTableMeta.getParentTableMeta()) {
            this.dealParentTableMeta(sql, leftJoinSql, parentTableMeta, tableAliasStack, parentTableAliasUsed, childFieldCodeList);
        }
        if (null != this.tableMeta.getParentTenantTableMeta()) {
            this.dealParentTableMeta(sql, leftJoinSql, this.tableMeta.getParentTenantTableMeta(), tableAliasStack, parentTableAliasUsed, childFieldCodeList);
        }
        if (!parentTableAliasUsed.isEmpty()) {
            sql.append(String.format(",\nJSON_MERGE_PRESERVE(`a`.`%s`, %s) AS `%s`", "_sys_dynamic", parentTableAliasUsed.stream().map(c -> String.format("`%s`.`%s`", c, "_sys_dynamic")).collect(Collectors.joining(", ")), "_sys_dynamic"));
        }
        sql.append("\n");
        sql.append(String.format("FROM `%s` `a`", this.tableMeta.getCode()));
        sql.append((CharSequence)leftJoinSql);
        sql.append("; \n");
        return sql.toString();
    }

    private String generateTenantBoViewSql(DdlOpEnum ddlOpEnum) {
        Stack<String> tableAliasStack = this.getTableAliasStack();
        if (null == this.tableMeta.getParentTableMeta()) {
            return "";
        }
        TableMeta mainTableMeta = this.tableMeta.getParentTableMeta();
        StringBuilder sql = new StringBuilder();
        Map<String, String> fieldCodeMap = mainTableMeta.getFieldMetas().stream().filter(fm -> !"_sys_dynamic".equals(fm.getCode())).collect(Collectors.toMap(FieldMeta::getCode, f -> String.format("`a`.`%s` AS `%s`", f.getCode(), f.getCode())));
        sql.append(String.format("%s VIEW `%s_%s` AS \n", ddlOpEnum.ddlOp(), this.tableMeta.getCode(), this.ddlContext.getViewAffix()));
        sql.append("SELECT ");
        sql.append(String.join((CharSequence)",", fieldCodeMap.values()));
        ArrayList<String> childFieldCodeList = new ArrayList<String>(fieldCodeMap.keySet());
        StringBuilder leftJoinSql = new StringBuilder();
        ArrayList<String> parentTableAliasUsed = new ArrayList<String>();
        for (TableMeta parentTableMeta = mainTableMeta.getParentTableMeta(); null != parentTableMeta; parentTableMeta = parentTableMeta.getParentTableMeta()) {
            this.dealParentTableMeta(sql, leftJoinSql, parentTableMeta, tableAliasStack, parentTableAliasUsed, childFieldCodeList);
        }
        if (null != this.tableMeta.getParentTenantTableMeta()) {
            this.dealParentTableMeta(sql, leftJoinSql, this.tableMeta.getParentTenantTableMeta(), tableAliasStack, parentTableAliasUsed, childFieldCodeList);
        }
        this.dealParentTableMeta(sql, leftJoinSql, this.tableMeta, tableAliasStack, parentTableAliasUsed, childFieldCodeList);
        if (!parentTableAliasUsed.isEmpty()) {
            sql.append(String.format(",\nJSON_MERGE_PRESERVE(`a`.`%s`, %s) AS `%s`", "_sys_dynamic", parentTableAliasUsed.stream().map(c -> String.format("`%s`.`%s`", c, "_sys_dynamic")).collect(Collectors.joining(", ")), "_sys_dynamic"));
        }
        sql.append("\n");
        sql.append(String.format("FROM `%s` `a`", mainTableMeta.getCode()));
        sql.append((CharSequence)leftJoinSql);
        sql.append("; \n");
        return sql.toString();
    }

    private void check() {
        if (this.ddlContext.getCharset() == null) {
            throw new RuntimeException("charset must not be null");
        }
        if (this.ddlOp == null) {
            throw new RuntimeException("ddl op must not be null");
        }
    }

    private void dealParentTableMeta(StringBuilder sql, StringBuilder leftJoinSql, TableMeta parentTableMeta, Stack<String> tableAliasStack, List<String> parentTableAliasUsed, List<String> childFieldCodeList) {
        String tableAlias = tableAliasStack.pop();
        parentTableAliasUsed.add(tableAlias);
        Map<String, String> parentFieldCodeMap = parentTableMeta.getFieldMetas().stream().filter(fm -> !"_sys_dynamic".equals(fm.getCode()) && !childFieldCodeList.contains(fm.getCode())).collect(Collectors.toMap(FieldMeta::getCode, f -> String.format("`%s`.`%s` AS `%s`", tableAlias, f.getCode(), f.getCode())));
        if (!parentFieldCodeMap.isEmpty()) {
            sql.append(", \n");
            sql.append(parentFieldCodeMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.joining(",")));
        }
        leftJoinSql.append(String.format("\nLEFT JOIN `%s` `%s` ON (`a`.`id` = `%s`.`id`) ", parentTableMeta.getCode(), tableAlias, tableAlias));
        parentFieldCodeMap.keySet().forEach(c -> childFieldCodeList.add((String)c));
    }

    private String convertToColumnType(String fieldType, FieldAttrMeta fieldAttr) {
        String mysqlFieldType;
        switch (fieldType) {
            case "int": {
                mysqlFieldType = this.convertToIntType(fieldAttr.getMaxLength());
                break;
            }
            case "tinyint": {
                mysqlFieldType = this.convertToTinyIntType(fieldAttr.getMaxLength());
                break;
            }
            case "datetime": {
                mysqlFieldType = this.convertToDateTimeType(fieldAttr.getMaxLength());
                break;
            }
            case "decimal": {
                mysqlFieldType = this.convertToDecimalType(fieldAttr.getMaxLength(), fieldAttr.getDecimalPoint());
                break;
            }
            case "bool": {
                mysqlFieldType = "boolean";
                break;
            }
            case "text": {
                mysqlFieldType = "text";
                break;
            }
            case "mediumtext": {
                mysqlFieldType = "mediumtext";
                break;
            }
            case "longtext": {
                mysqlFieldType = "longtext";
                break;
            }
            case "json": {
                mysqlFieldType = "json";
                break;
            }
            default: {
                mysqlFieldType = this.convertToStringType(fieldAttr.getMaxLength());
            }
        }
        return mysqlFieldType;
    }

    private String convertToIntType(Integer length) {
        return String.format("bigint(%d)", null != length ? length : 255);
    }

    private String convertToTinyIntType(Integer length) {
        return String.format("tinyint(%d)", null != length ? length : 255);
    }

    private String convertToStringType(Integer length) {
        return ObjectType.TABLE.equals((Object)this.type) ? String.format("varchar(%d)", null != length ? length : 255) : String.format("varchar(%d) CHARACTER SET %s", null != length ? length : 255, this.ddlContext.getCharset());
    }

    private String convertToDecimalType(Integer length, Integer decimalPoint) {
        return String.format("decimal(%d, %d)", length, decimalPoint);
    }

    private String convertToDateTimeType(Integer digit) {
        return "datetime";
    }

    private String generateDefaultValue(String fieldType, FieldAttrMeta fieldAttr) {
        String rs = "";
        if (!StringUtils.isEmpty((Object)fieldAttr.getDefaultValue())) {
            if (this.NUMERIC_FIELD_TYPES.contains(fieldType)) {
                rs = String.format(" DEFAULT %s", fieldAttr.getDefaultValue());
            } else if ("datetime".equals(fieldType)) {
                if ("CURRENT_TIMESTAMP".equals(fieldAttr.getDefaultValue())) {
                    rs = " DEFAULT CURRENT_TIMESTAMP";
                }
            } else if (!"json".equals(fieldType) && !this.TEXT_FIELD_TYPES.contains(fieldType)) {
                rs = String.format(" DEFAULT '%s'", fieldAttr.getDefaultValue());
            }
        }
        return rs;
    }

    private Stack<String> getTableAliasStack() {
        Stack<String> tableAliasStack = new Stack<String>();
        tableAliasStack.push("e");
        tableAliasStack.push("d");
        tableAliasStack.push("c");
        tableAliasStack.push("b");
        return tableAliasStack;
    }

    private String getIndexFieldCodesSql(String fieldCodes) {
        return Stream.of(fieldCodes.split(",")).map(c -> String.format("`%s`", c.trim())).collect(Collectors.joining(", "));
    }

    private static enum ObjectType {
        TABLE,
        INDEX,
        FIELD,
        VIEW;

    }
}

