/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.autodb.sql.create;

import com.xforceplus.ultraman.bocp.gen.autodb.po.BoField;
import com.xforceplus.ultraman.bocp.gen.autodb.po.BoInfo;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.create.CreateModel;
import com.xforceplus.ultraman.bocp.gen.autodb.sql.mysql.MysqlGenUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class CreateDSL {
    public static String create(CreateModel createModel) {
        StringBuffer sql = new StringBuffer();
        if (createModel == null) {
            return null;
        }
        if (createModel.getBoInfoList() != null) {
            List<BoInfo> boInfos = createModel.getBoInfoList();
            for (BoInfo bo : boInfos) {
                if (createModel.getDropCf() != null && createModel.getDropCf().booleanValue()) {
                    sql.append("drop table if exists " + bo.getName() + ";");
                    sql.append("\n");
                }
                if (createModel.getDeleteCf() != null && createModel.getDeleteCf().booleanValue()) {
                    sql.append("delete table if exists " + bo.getName() + ";");
                    sql.append("\n");
                }
                sql.append("create table " + bo.getName() + " " + "(");
                sql.append("\n");
                List<BoField> fields = bo.getBoFieldList();
                if (fields == null) {
                    sql.append("id bigint NOT NULL COMMENT 'id',");
                    sql.append("PRIMARY KEY (id)");
                    sql.append(")");
                    sql.append("\n");
                    sql.append("alter table " + bo.getName() + " " + "COMMENT" + " " + "'" + bo.getRemark() + "'" + ";");
                    sql.append("\n");
                    break;
                }
                for (BoField field : fields) {
                    boolean last;
                    sql.append("  " + field.getName() + " ");
                    sql.append(MysqlGenUtil.convertToMysqlColumnType(field));
                    if (!StringUtils.isEmpty((String)field.getNullKey())) {
                        sql.append("NOT NULL ");
                    }
                    if ("1".equals(field.getFieldKey())) {
                        sql.append("PRIMARY KEY ");
                    }
                    if (!StringUtils.isEmpty((String)field.getRemark())) {
                        sql.append("COMMENT '" + field.getRemark() + "'");
                    }
                    boolean bl = last = field.getName() == fields.get(fields.size() - 1).getName();
                    if (!last) {
                        sql.append(",");
                    }
                    sql.append("\n");
                }
                sql.append(");");
                sql.append("\n");
                sql.append("alter table " + bo.getName() + " " + "COMMENT" + " " + "'" + bo.getRemark() + "'" + ";");
                sql.append("\n");
            }
        }
        return sql.toString();
    }
}

