/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.bocp.gen.autodb.sql.mysql;

import com.xforceplus.ultraman.bocp.gen.autodb.po.BoField;

public class MysqlGenUtil {
    public static String convertToMysqlColumnType(BoField field) {
        String mysqlFieldType;
        switch (field.getFieldType()) {
            case "int": {
                mysqlFieldType = MysqlGenUtil.convertToMysqlIntType(field.getLength());
                break;
            }
            case "datetime": {
                mysqlFieldType = "datetime";
                break;
            }
            case "decimal": {
                mysqlFieldType = MysqlGenUtil.convertToMysqlDecimalType(field.getLength(), field.getDecimalPoint());
                break;
            }
            case "bool": {
                mysqlFieldType = "boolean";
                break;
            }
            case "text": {
                mysqlFieldType = "text";
                break;
            }
            case "mediumtext": {
                mysqlFieldType = "mediumtext";
                break;
            }
            case "longtext": {
                mysqlFieldType = "longtext";
                break;
            }
            case "json": {
                mysqlFieldType = "json";
                break;
            }
            default: {
                mysqlFieldType = MysqlGenUtil.convertToMysqlStringType(field.getLength());
            }
        }
        return mysqlFieldType + " ";
    }

    public static String convertToMysqlIntType(Integer length) {
        return "bigint(" + (null != length ? length : 255) + ")";
    }

    public static String convertToMysqlStringType(Integer length) {
        return "varchar(" + (null != length ? length : 255) + ")" + " " + "CHARACTER SET utf8";
    }

    public static String convertToMysqlDecimalType(Integer length, Integer decimalPoint) {
        return "decimal(" + length + "," + " " + decimalPoint + ")";
    }
}

