/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.ultraman.bocp.metadata.apis.pojo.ApiDetails;
import com.xforceplus.ultraman.bocp.metadata.apis.utils.MapperConvertUtils;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Apis;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantApiManagementService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantApiManagementServiceImpl
implements ITenantApiManagementService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<Apis> getApis(Long tenantAppId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantAppId);
        List stdApis = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Apis.class);
        stdApis.forEach(o -> o.setId(o.getUniqueId()));
        return stdApis;
    }

    @Override
    public List<ApiDetails> getApiDetails(Long appId, Boolean onlyBasic, Boolean discard, Apis apis) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appId);
        List<Apis> stdApis = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Apis.class);
        stdApis = stdApis.stream().filter(o -> o.getDiscard().equals(null != discard && discard != false)).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)apis.getApiCode())) {
            stdApis = stdApis.stream().filter(r -> null != r.getApiCode() && r.getApiCode().contains(apis.getApiCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)apis.getApiType())) {
            stdApis = stdApis.stream().filter(r -> null != r.getApiType() && r.getApiType().equals(apis.getApiType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)apis.getUrl())) {
            stdApis = stdApis.stream().filter(r -> null != r.getUrl() && r.getUrl().contains(apis.getUrl())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)apis.getApiDesc())) {
            stdApis = stdApis.stream().filter(r -> null != r.getApiDesc() && r.getApiDesc().contains(apis.getApiDesc())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)apis.getApiServiceCode())) {
            stdApis = stdApis.stream().filter(r -> null != r.getApiServiceCode() && r.getApiServiceCode().contains(apis.getApiServiceCode())).collect(Collectors.toList());
        }
        ArrayList<ApiDetails> apiDetails = new ArrayList<ApiDetails>();
        if (null == onlyBasic || onlyBasic.booleanValue()) {
            stdApis.forEach(result -> apiDetails.add(MapperConvertUtils.toApiBasic((Apis)result)));
        } else {
            stdApis.forEach(result -> apiDetails.add(MapperConvertUtils.toApiDetails((Apis)result)));
        }
        return apiDetails;
    }
}

