/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEvent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppEventExService;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantAppEventExServiceImpl
implements ITenantAppEventExService {
    private static final Logger log = LoggerFactory.getLogger(TenantAppEventExServiceImpl.class);
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<AppEvent> queryEvents(AppEvent appEvent) {
        AppRef appRef = this.appCustomValidator.validateAppRef(appEvent.getAppId());
        List stdAppEvents = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getAppId(), appRef.getRefAppVersion(), AppEvent.class);
        if (StringUtils.isNotBlank((CharSequence)appEvent.getEventType())) {
            stdAppEvents = stdAppEvents.stream().filter(o -> appEvent.getEventType().equals(o.getEventType())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)appEvent.getEventName())) {
            stdAppEvents = stdAppEvents.stream().filter(o -> o.getEventName() != null && o.getEventName().contains(appEvent.getEventName())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)appEvent.getEventCode())) {
            stdAppEvents = stdAppEvents.stream().filter(o -> o.getEventCode() != null && o.getEventCode().contains(appEvent.getEventCode())).collect(Collectors.toList());
        }
        if (StringUtils.isNotBlank((CharSequence)appEvent.getEventSource())) {
            stdAppEvents = stdAppEvents.stream().filter(o -> appEvent.getEventSource().equals(o.getEventSource())).collect(Collectors.toList());
        }
        return stdAppEvents.stream().map(o -> o.setId(o.getPublishEventId())).sorted(Comparator.comparing(AppEvent::getId).reversed()).collect(Collectors.toList());
    }
}

