/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PfcpPublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.vo.BoReferenceInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.DictReferenceInfoVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.FlowSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.FlowSettingMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoFieldService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.FlowSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.PageBoSettingRepository;
import com.xforceplus.ultraman.metadata.repository.pfcp.repository.UltFormRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppMetadataReferenceService;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.PageBoSetting;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltForm;
import com.xforceplus.ultraman.pfcp.mybatisplus.entity.UltPage;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.PageBoSettingMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltFormMapper;
import com.xforceplus.ultraman.pfcp.mybatisplus.mapper.UltPageMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantAppMetadataReferenceService
implements ITenantAppMetadataReferenceService {
    @Autowired
    private UltPageMapper ultPageMapper;
    @Autowired
    private PageBoSettingMapper pageBoSettingMapper;
    @Autowired
    private UltFormMapper ultFormMapper;
    @Autowired
    private FlowSettingMapper flowSettingMapper;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private IBoFieldService boFieldService;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private UltFormRepository ultFormRepository;
    @Autowired
    private FlowSettingRepository flowSettingRepository;
    @Autowired
    private PageBoSettingRepository pageBoSettingRepository;

    @Override
    public ServiceResponse getBoReferences(Long appId, Long boId) {
        Bo bo = this.boRepository.getBo(appId, boId).orElse(null);
        if (bo == null) {
            return ServiceResponse.fail((String)"");
        }
        BoReferenceInfoVo boReferenceInfo = new BoReferenceInfoVo();
        List pages = this.ultPageMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltPage::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltPage::getDeleteFlag, (Object)"1")).eq(UltPage::getTenantCode, (Object)bo.getTenantCode())).eq(UltPage::getAppId, (Object)appId));
        List pageIds = pages.stream().map(UltPage::getId).collect(Collectors.toList());
        ArrayList referencePageIds = pageIds.isEmpty() ? Lists.newArrayList() : this.pageBoSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(PageBoSetting::getDeleteFlag, (Object)"1")).in(PageBoSetting::getPageId, pageIds)).stream().filter(pageBoSetting -> !StringUtils.isEmpty((CharSequence)pageBoSetting.getSetting()) && pageBoSetting.getSetting().contains("\"entityId\":\"" + bo.getRefBoId() + "\",")).map(PageBoSetting::getPageId).distinct().collect(Collectors.toList());
        boReferenceInfo.setPages(pages.stream().filter(page -> referencePageIds.contains(page.getId())).collect(Collectors.toList()));
        List forms = this.ultFormMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UltForm::getPublishFlag, (Object)PfcpPublishFlag.UNPUBLISHED.code())).eq(UltForm::getDeleteFlag, (Object)"1")).eq(UltForm::getTenantCode, (Object)bo.getTenantCode())).eq(UltForm::getAppId, (Object)appId));
        boReferenceInfo.setForms(forms.stream().filter(form -> !StringUtils.isEmpty((CharSequence)form.getSetting()) && form.getSetting().contains("\"entityId\":\"" + bo.getRefBoId() + "\",")).map(form -> form.setSetting(null)).collect(Collectors.toList()));
        List flowSettings = this.flowSettingMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(FlowSetting.class, info -> !info.getColumn().equals("flow_setting_front")).eq(FlowSetting::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(FlowSetting::getDeleteFlag, (Object)"1")).eq(FlowSetting::getTenantCode, (Object)bo.getTenantCode())).eq(FlowSetting::getAppId, (Object)appId));
        boReferenceInfo.setFlowSettings(flowSettings.stream().filter(flowSetting -> flowSetting.getFlowSetting() != null && flowSetting.getFlowSetting().contains("\"boCode\":\"" + bo.getCode() + "\"")).collect(Collectors.toList()));
        return ServiceResponse.success((String)"", (Object)boReferenceInfo);
    }

    @Override
    public ServiceResponse getDictReferences(Long appId, Long dictId) {
        Dict dict = this.dictRepository.getDict(appId, dictId).orElse(null);
        if (dict == null) {
            return ServiceResponse.fail((String)"");
        }
        DictReferenceInfoVo dictReferenceInfoVo = new DictReferenceInfoVo();
        Map boMap = this.boRepository.getBos(appId.longValue()).stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        HashMap boFieldMap = boMap.isEmpty() ? Maps.newHashMap() : this.boFieldService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoField::getBoId, boMap.keySet())).eq(BoField::getDeleteFlag, (Object)"1")).eq(BoField::getDictId, (Object)dictId)).stream().collect(Collectors.groupingBy(BoField::getBoId));
        List bos = this.boRepository.getBosByIds(new ArrayList(boFieldMap.keySet()));
        dictReferenceInfoVo.setBos(bos.stream().map(bo -> BoStructMapper.MAPPER.toInfoVo(bo).setFields(((List)boFieldMap.get(bo.getId())).stream().map(arg_0 -> ((BoFieldStructMapper)BoFieldStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()))).collect(Collectors.toList()));
        return ServiceResponse.success((String)"", (Object)dictReferenceInfoVo);
    }

    @Override
    public ServiceResponse updateBoReferences(Long appId, Bo originBo, Bo bo) {
        List flowIds;
        List formIds;
        List pageIds;
        ServiceResponse serviceResponse = this.getBoReferences(appId, bo.getId());
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        BoReferenceInfoVo boReferenceInfo = (BoReferenceInfoVo)serviceResponse.getData();
        if (CollectionUtils.isNotEmpty((Collection)boReferenceInfo.getPages()) && !(pageIds = boReferenceInfo.getPages().stream().map(UltPage::getId).collect(Collectors.toList())).isEmpty()) {
            this.pageBoSettingRepository.getPageBoSettingsByPageIds(pageIds).stream().filter(pageSetting -> !StringUtils.isEmpty((CharSequence)pageSetting.getSetting()) && pageSetting.getSetting().contains("\"entityId\":\"" + originBo.getId() + "\"")).forEach(pageSetting -> {
                pageSetting.setBoName(bo.getName()).setBoCode(bo.getCode()).setSetting(pageSetting.getSetting().replace("\"entityCode\":\"" + originBo.getCode() + "\"", "\"entityCode\":\"" + bo.getCode() + "\""));
                this.pageBoSettingMapper.updateById(pageSetting);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)boReferenceInfo.getForms()) && !(formIds = boReferenceInfo.getForms().stream().map(UltForm::getId).collect(Collectors.toList())).isEmpty()) {
            this.ultFormRepository.getFormsByIds(formIds).stream().filter(form -> !StringUtils.isEmpty((CharSequence)form.getSetting()) && form.getSetting().contains("\"entityId\":\"" + originBo.getId() + "\"")).forEach(form -> {
                form.setBoName(bo.getName()).setBoCode(bo.getCode()).setSetting(form.getSetting().replace("\"entityCode\":\"" + originBo.getCode() + "\"", "\"entityCode\":\"" + bo.getCode() + "\""));
                this.ultFormMapper.updateById(form);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)boReferenceInfo.getFlowSettings()) && !(flowIds = boReferenceInfo.getFlowSettings().stream().map(FlowSetting::getId).collect(Collectors.toList())).isEmpty()) {
            this.flowSettingRepository.getFlowSettingsByIdsWithoutFrontSetting(flowIds).forEach(flow -> {
                flow.setFlowSettingFront(flow.getFlowSettingFront().replace("\"boId\":\"" + originBo.getId() + "\",\"name\":\"" + originBo.getName() + "\",\"code\":\"" + originBo.getCode() + "\"", "\"boId\":\"" + bo.getId() + "\",\"name\":\"" + bo.getName() + "\",\"code\":\"" + bo.getCode() + "\"")).setFlowSetting(flow.getFlowSetting().replace("\"boCode\":\"" + originBo.getCode() + "\"", "\"boCode\":\"" + bo.getCode() + "\""));
                this.flowSettingMapper.updateById(flow);
            });
        }
        return ServiceResponse.success();
    }
}

