/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.tenant.core.exception.TenantFeignException;
import com.xforceplus.ultraman.bocp.metadata.constant.BocpConstant;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CommonStatus;
import com.xforceplus.ultraman.bocp.metadata.event.AppEvent;
import com.xforceplus.ultraman.bocp.metadata.event.enums.AppEventType;
import com.xforceplus.ultraman.bocp.metadata.infra.util.UserUtils;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.AppStructMapper;
import com.xforceplus.ultraman.bocp.metadata.service.IAppExService;
import com.xforceplus.ultraman.bocp.metadata.service.IDictExService;
import com.xforceplus.ultraman.bocp.metadata.service.IModuleInfoExService;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppModule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.UserAppRoleAuth;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.UserTenantAuth;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppModuleService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppRefService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IUserAppRoleAuthService;
import com.xforceplus.ultraman.metadata.bocp.auth.repository.UserRepository;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.global.common.util.AppTenantUtil;
import com.xforceplus.ultraman.metadata.repository.aop.annotation.SkipDataAuth;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DeployEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantAppServiceImpl
implements ITenantAppService {
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private IAppService appService;
    @Autowired
    private IAppModuleService appModuleService;
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private IAppExService appExService;
    @Autowired
    private IModuleInfoExService moduleInfoExService;
    @Autowired
    private IDictExService dictExService;
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DeployEnvRepository deployEnvRepository;
    @Autowired
    private IUserAppRoleAuthService userAppRoleAuthService;
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private IAppRefService appRefService;

    @Override
    @SkipDataAuth
    public List<App> getApps(Long appId) {
        List tenantApps = this.appService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(App::getDeleteFlag, (Object)"1")).eq(App::getCustomType, (Object)AppCustomType.TENANT.code())).eq(App::getRefAppId, (Object)appId));
        if (UserUtils.isUltramanAdmin()) {
            return tenantApps;
        }
        List appIds = this.userAppRoleAuthService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(UserAppRoleAuth::getUserId, (Object)UserUtils.getUserId())).eq(UserAppRoleAuth::getDeleteFlag, (Object)"1")).stream().map(UserAppRoleAuth::getAppId).distinct().collect(Collectors.toList());
        return tenantApps.stream().filter(a -> appIds.contains(a.getId())).collect(Collectors.toList());
    }

    @Override
    @Transactional
    public ServiceResponse createTenantApp(App tenantApp) {
        List userTenantCodes;
        if (StringUtils.isEmpty((CharSequence)tenantApp.getTenantCode())) {
            return ServiceResponse.fail((String)"\u79df\u6237\u4ee3\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UserUtils.isUltramanAdmin() && !(userTenantCodes = this.userRepository.getTenants(UserUtils.getUserId()).stream().map(UserTenantAuth::getTenantCode).collect(Collectors.toList())).contains(tenantApp.getTenantCode())) {
            return ServiceResponse.fail((String)"\u7528\u6237\u6ca1\u6709\u6743\u9650\u4e3a\u8be5\u79df\u6237\u521b\u5efa\u79df\u6237\u5b9a\u5236");
        }
        if (null == tenantApp.getRefAppId()) {
            return ServiceResponse.fail((String)"\u6807\u51c6\u5e94\u7528ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        App standardApp = this.appRepository.getAppWithValidateSkipDataAuth(tenantApp.getRefAppId().longValue());
        if (!AppCustomType.STANDARD.code().equals(standardApp.getCustomType())) {
            return ServiceResponse.fail((String)"\u6839\u636e\u6807\u51c6\u5e94\u7528ID\u67e5\u5230\u7684\u5e94\u7528\u4e0d\u662f\u6807\u51c6\u5e94\u7528");
        }
        Map tenantAppListMap = this.appExService.getAppTenantList(tenantApp.getRefAppId());
        for (MetadataType metadataType : tenantAppListMap.keySet()) {
            if (!((List)tenantAppListMap.get(metadataType)).contains(tenantApp.getTenantCode())) continue;
            return ServiceResponse.fail((String)String.format("\u6807\u51c6\u5e94\u7528\u7684%s\u5b58\u5728\u79df\u6237\u5b9a\u5236\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u79df\u6237\u5b9a\u5236\u5e94\u7528", metadataType.desc()));
        }
        Optional tenantAppOptional = this.appRepository.getTenantAppSkipDataAuth(tenantApp.getRefAppId().longValue(), tenantApp.getTenantCode());
        if (tenantAppOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u79df\u6237\u5b9a\u5236\u5e94\u7528\u5df2\u5b58\u5728");
        }
        AppEnv refAppProdEnv = this.appEnvRepository.getAppEnvWithValidateSkipDataAuth(tenantApp.getRefAppId().longValue(), BocpConstant.PROD_APP_ENV_ID.longValue());
        if (null == refAppProdEnv.getAppVersionId()) {
            throw new RuntimeException("\u6807\u51c6\u5e94\u7528\u6ca1\u6709\u5728\u6b63\u5f0f\u73af\u5883\u90e8\u7f72\u8fc7\u7248\u672c\uff0c\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        App app = AppStructMapper.MAPPER.clone(standardApp);
        app.setId(null);
        app.setUniqueId(null);
        app.setRefAppId(tenantApp.getRefAppId());
        app.setCustomType(AppCustomType.TENANT.code());
        app.setTenantCode(tenantApp.getTenantCode());
        app.setTenantName(tenantApp.getTenantName());
        app.setRemark(tenantApp.getRemark());
        this.appService.save((Object)app);
        this.defaultModuleService.createDefaultModule(app.getId().longValue());
        this.deployEnvRepository.getSysEnv().forEach(deployEnv -> {
            AppEnv appEnv = new AppEnv();
            appEnv.setEnvId(deployEnv.getId());
            appEnv.setAppId(app.getId());
            appEnv.setStatus(CommonStatus.ENABLE.code());
            appEnv.setNodeNum(Integer.valueOf(1));
            this.appEnvService.save((Object)appEnv);
        });
        this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppEvent((Object)this, AppEventType.REF, app));
        try {
            String tenantAppCode = AppTenantUtil.getLowerHyphenAppCode((String)app.getCode(), (String)app.getTenantCode());
            App tenantAppInfo = new App().setId(app.getId()).setCode(tenantAppCode).setName(tenantAppCode);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppEvent((Object)this, AppEventType.CREATE, tenantAppInfo));
        }
        catch (TenantFeignException e) {
            return ServiceResponse.success((String)e.getMessage(), (Object)app);
        }
        return ServiceResponse.success();
    }

    @Override
    public ServiceResponse logicRemoveTenantAppById(Long appId) {
        App app = this.appRepository.getAppWithValidate(appId.longValue());
        if (!AppCustomType.TENANT.code().equals(app.getCustomType())) {
            return ServiceResponse.fail((String)"\u975e\u79df\u6237\u5b9a\u5236\u5e94\u7528");
        }
        this.appRepository.logicRemoveById(appId.longValue());
        this.appModuleService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(AppModule::getApplicationId, (Object)appId)).eq(AppModule::getDeleteFlag, (Object)"1")).forEach(module -> this.moduleInfoExService.logicRemoveById(module.getId()));
        this.dictRepository.getDicts(appId).forEach(dict -> this.dictExService.logicRemoveById(dict.getId()));
        this.appRefService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate().eq(AppRef::getAppId, (Object)appId)).eq(AppRef::getDeleteFlag, (Object)"1")).set(AppRef::getDeleteFlag, (Object)"0"));
        try {
            String tenantAppCode = AppTenantUtil.getLowerHyphenAppCode((String)app.getCode(), (String)app.getTenantCode());
            App tenantAppInfo = new App().setId(app.getId()).setCode(tenantAppCode).setName(tenantAppCode);
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppEvent((Object)this, AppEventType.REMOVE, tenantAppInfo));
        }
        catch (TenantFeignException e) {
            return ServiceResponse.fail((String)e.getMessage());
        }
        return ServiceResponse.success();
    }
}

