/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.tenant.security.token.domain.TokenUser;
import com.xforceplus.ultraman.bocp.metadata.constant.BocpConstant;
import com.xforceplus.ultraman.bocp.metadata.deploy.service.IAppVersionDeploySync20Service;
import com.xforceplus.ultraman.bocp.metadata.deploy.service.IDataRuleDeployService;
import com.xforceplus.ultraman.bocp.metadata.deploy.service.impl.AppVersionDeployServiceImpl;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.AppType;
import com.xforceplus.ultraman.bocp.metadata.enums.EnvStatus;
import com.xforceplus.ultraman.bocp.metadata.service.IAppEnvDeployDetailExService;
import com.xforceplus.ultraman.bocp.metadata.service.IAppRoleAuthExService;
import com.xforceplus.ultraman.bocp.metadata.util.VersionUtils;
import com.xforceplus.ultraman.bocp.metadata.version.event.AppVersionUploadOSSEvent;
import com.xforceplus.ultraman.bocp.metadata.version.event.enums.UploadOSSEventType;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.vo.DeployContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppEnv;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppEnvService;
import com.xforceplus.ultraman.metadata.repository.aop.dataauth.MybatisThreadLocal;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppEnvRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRepository;
import com.xforceplus.ultraman.metadata.tenant.validator.TenantAppMetadataValidator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service(value="tenantAppVersionDeployService")
public class TenantAppVersionDeployServiceImpl
extends AppVersionDeployServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(TenantAppVersionDeployServiceImpl.class);
    @Autowired
    private AppRepository appRepository;
    @Autowired
    private IAppEnvService appEnvService;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private IDataRuleDeployService dataRuleDeployService;
    @Autowired
    private IAppVersionDeploySync20Service appVersionDeploySync20Service;
    @Autowired
    private IAppEnvDeployDetailExService appEnvDeployDetailExService;
    @Autowired
    private AppEnvRepository appEnvRepository;
    @Autowired
    private TenantAppMetadataValidator tenantAppMetadataValidator;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;
    @Autowired
    private IAppRoleAuthExService appRoleAuthExService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse deployAppVersion(DeployContent deployContent) {
        boolean isAppAdmin;
        log.info("app deploy start :{}", (Object)deployContent);
        App app = this.appRepository.getAppWithValidate(deployContent.getAppId().longValue());
        AppVersion appVersion = this.appVersionQuery.getAppVersionWithValidate(deployContent.getAppVersionId());
        AppEnv appEnv = this.appEnvRepository.getAppEnvWithValidate(deployContent.getAppId().longValue(), deployContent.getEnvId().longValue());
        if (EnvStatus.DISABLE.code().equals(appEnv.getStatus())) {
            return ServiceResponse.fail((String)"\u73af\u5883\u5df2\u505c\u7528");
        }
        if (BocpConstant.PROD_APP_ENV_ID.equals(deployContent.getEnvId()) && !(isAppAdmin = this.appRoleAuthExService.isAppAdmin(deployContent.getAppId()))) {
            List userDtos = this.appRoleAuthExService.appAdmins(deployContent.getAppId());
            String adminsStr = userDtos.stream().map(TokenUser::getEmail).collect(Collectors.joining(","));
            if (StringUtils.isNotBlank((CharSequence)adminsStr)) {
                adminsStr = "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff1a" + adminsStr;
            }
            return ServiceResponse.fail((String)String.format("\u975e\u7ba1\u7406\u5458\u4e0d\u5141\u8bb8\u90e8\u7f72\u6b63\u5f0f\u73af\u5883.%s", adminsStr));
        }
        this.tenantAppMetadataValidator.validateWhenTenantAppDeploy(deployContent.getAppId(), deployContent.getEnvId(), appVersion);
        if (deployContent.isForceUpdate()) {
            Integer deployVersionIntOqs = Optional.ofNullable(VersionUtils.computeVersionIntForOqs((String)appEnv.getDeployVersion())).orElse(0);
            Integer willDeployVersionIntOqs = Optional.ofNullable(VersionUtils.computeVersionIntForOqs((String)appVersion.getVersion())).orElse(0);
            if (willDeployVersionIntOqs >= deployVersionIntOqs) {
                return ServiceResponse.fail((String)"\u56de\u6eda\u64cd\u4f5c\uff0c\u90e8\u7f72\u7248\u672c\u5fc5\u987b\u5c0f\u4e8e\u5df2\u90e8\u7f72\u7248\u672c");
            }
        }
        if (AppType.getSync20TypeCodeList().contains(app.getType()) && "0".equals(appVersion.getOssFlag())) {
            return ServiceResponse.fail((String)String.format("\u90e8\u7f72\u7684\u7248\u672c\u914d\u7f6e\uff08%s\uff09\u9884\u5904\u7406\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", appVersion.getVersion()));
        }
        MybatisThreadLocal.getInstance().setSkipDataAuth(true);
        try {
            ServiceResponse<AppEnv> serviceResponse = this.doDeployAppVersion(deployContent, app, appEnv, appVersion);
            return serviceResponse;
        }
        finally {
            MybatisThreadLocal.getInstance().setSkipDataAuth(false);
        }
    }

    private void computeAndUpdateVersionNo(AppEnv stdAppEnv, AppVersion stdAppVersion) {
        stdAppEnv.setDeployVersionNumOqs(Optional.ofNullable(stdAppEnv.getDeployVersionNumOqs()).map(n -> n + 1).orElse(0));
        stdAppEnv.setDeployVersionNum(Optional.ofNullable(stdAppEnv.getDeployVersionNum()).orElse(0));
        Integer deployVersionNum = Optional.ofNullable(VersionUtils.computeVersionInt((String)stdAppVersion.getVersion())).orElse(0);
        if (deployVersionNum.equals(stdAppEnv.getDeployVersionNum())) {
            stdAppEnv.setDeployVersionNum(Integer.valueOf(VersionUtils.VERSION_CHANGE_SIGN + stdAppEnv.getDeployVersionNum()));
        } else {
            stdAppEnv.setDeployVersionNum(deployVersionNum);
        }
    }

    private ServiceResponse<AppEnv> doDeployAppVersion(final DeployContent deployContent, final App app, final AppEnv appEnv, final AppVersion appVersion) {
        final App stdApp = this.appRepository.getAppWithValidate(app.getRefAppId().longValue());
        AppEnv stdAppEnv = this.appEnvRepository.getAppEnvWithValidate(app.getRefAppId().longValue(), appEnv.getEnvId().longValue());
        AppVersion stdAppVersion = this.appVersionQuery.getAppVersionWithValidate(stdAppEnv.getAppVersionId());
        if (AppType.getSync20TypeCodeList().contains(app.getType())) {
            this.doDeploySync20(deployContent, appVersion);
        } else {
            this.doDeploySync15(deployContent, appVersion);
        }
        final Long originVersionId = appEnv.getAppVersionId();
        this.updateAppEnv(appEnv, appVersion, deployContent.getDeployRemark());
        log.info("tenant app deploy complete: {}", (Object)appEnv);
        appEnv.setId(stdAppEnv.getId());
        this.appEnvDeployDetailExService.save(app, appEnv, appVersion);
        this.computeAndUpdateVersionNo(stdAppEnv, stdAppVersion);
        this.appEnvService.updateById((Object)stdAppEnv);
        if (AppType.getSync20TypeCodeList().contains(app.getType())) {
            this.appVersionDeploySync20Service.deploy(stdApp, stdAppVersion.getVersion(), deployContent.getEnvId(), true);
        }
        TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

            public void afterCommit() {
                TenantAppVersionDeployServiceImpl.this.dataRuleDeployService.deployAsyncForTenantApp(stdApp.getId(), deployContent.getEnvId(), app.getId(), app.getTenantCode(), originVersionId, appEnv.getAppVersionId());
                TenantAppVersionDeployServiceImpl.this.applicationEventPublisher.publishEvent((ApplicationEvent)new AppVersionUploadOSSEvent((Object)this, UploadOSSEventType.DEPLOY, appEnv.getEnvId(), app.getId(), appVersion));
            }
        });
        return ServiceResponse.success((String)"\u90e8\u7f72\u6210\u529f", (Object)stdAppEnv);
    }
}

