/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.version.query.AppVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.query.BoVersionQuery;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppVersionMetadataMergeService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantAppVersionMetadataMergeServiceImpl
implements ITenantAppVersionMetadataMergeService {
    @Autowired
    private AppRefRepository appRefRepository;
    @Autowired
    private AppVersionQuery appVersionQuery;
    @Autowired
    private BoVersionQuery boVersionQuery;
    @Autowired
    private BoRepository boRepository;

    @Override
    public List<Bo> getBos(Long tenantAppId) {
        AppRef appRef = this.appRefRepository.getAppRefWithValidate(tenantAppId.longValue());
        List stdVBos = this.boVersionQuery.getBosSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion());
        List tenantBos = this.boRepository.getBos(tenantAppId.longValue());
        Map<Long, Long> boIdMapping = stdVBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertBoUniIdToVersionId((List)tenantBos, boIdMapping);
        tenantBos.forEach(o -> o.setAppId(appRef.getRefAppId()));
        return ListUtils.union((List)tenantBos, (List)stdVBos);
    }

    @Override
    public List<Bo> getVersionBos(Long tenantAppVersionId) {
        AppVersion tenantAppVersion = this.appVersionQuery.getAppVersionWithValidate(tenantAppVersionId);
        this.appVersionQuery.getAppVersionWithValidateSkipDataAuth(tenantAppVersion.getRefAppId(), tenantAppVersion.getRefVersion());
        List stdVBos = this.boVersionQuery.getBosSkipDataAuth(tenantAppVersion.getRefAppId(), tenantAppVersion.getRefVersion());
        List<Bo> tenantVBos = this.boVersionQuery.getBos(tenantAppVersion.getAppId(), tenantAppVersion.getVersion()).stream().map(arg_0 -> ((BoStructMapper)BoStructMapper.MAPPER).clone(arg_0)).collect(Collectors.toList());
        Map<Long, Long> boIdMapping = stdVBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertBoUniIdToVersionId(tenantVBos, boIdMapping);
        tenantVBos.forEach(o -> o.setAppId(tenantAppVersion.getRefAppId()));
        return ListUtils.union(tenantVBos, (List)stdVBos);
    }
}

