/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppVersionPublishService;
import com.xforceplus.ultraman.bocp.metadata.version.vo.PublishContent;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppVersion;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IAppVersionService;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppVersionPublishService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantAppVersionPublishServiceImpl
implements ITenantAppVersionPublishService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private IAppVersionPublishService appVersionPublishService;
    @Autowired
    private IAppVersionService appVersionService;

    @Override
    public ServiceResponse<AppVersion> publishAppVersion(PublishContent publishContent) {
        AppRef appRef = this.appCustomValidator.validateAppRef(publishContent.getAppId());
        ServiceResponse serviceResponse = this.appVersionPublishService.publishAppVersion(publishContent);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        AppVersion newAppVersion = (AppVersion)serviceResponse.getData();
        newAppVersion.setRefAppId(appRef.getRefAppId());
        newAppVersion.setRefVersion(appRef.getRefAppVersion());
        this.appVersionService.updateById((Object)newAppVersion);
        return ServiceResponse.success((String)"", (Object)newAppVersion);
    }

    @Override
    public ServiceResponse<AppVersion> publishAppPatchVersion(Long appVersionId, PublishContent publishContent) {
        AppRef appRef = this.appCustomValidator.validateAppRef(publishContent.getAppId());
        ServiceResponse serviceResponse = this.appVersionPublishService.publishAppPatchVersion(appVersionId, publishContent);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        AppVersion newAppVersion = (AppVersion)serviceResponse.getData();
        newAppVersion.setRefAppId(appRef.getRefAppId());
        newAppVersion.setRefVersion(appRef.getRefAppVersion());
        this.appVersionService.updateById((Object)newAppVersion);
        return ServiceResponse.success((String)"", (Object)newAppVersion);
    }
}

