/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.datarule.enums.DataRuleStatus;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.mapstruct.BoDataRuleStructMapper;
import com.xforceplus.ultraman.bocp.metadata.datarule.validator.DataRuleValidator;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleDetailVo;
import com.xforceplus.ultraman.bocp.metadata.datarule.vo.DataRuleVo;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.validator.ValidateResponse;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRule;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoDataRuleDetail;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoDataRuleService;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoDataRuleExService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class TenantBoDataRuleExServiceImpl
implements ITenantBoDataRuleExService {
    @Autowired
    private DataRuleValidator dataRuleValidator;
    @Autowired
    private IBoDataRuleService boDataRuleService;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private IBoDataRuleDetailService boDataRuleDetailService;

    @Override
    public ServiceResponse saveDataRule(DataRuleVo dataRuleVo) {
        ValidateResponse validateResponse = this.dataRuleValidator.validateCreateDefault(dataRuleVo);
        if (validateResponse.failed()) {
            return ServiceResponse.fail((String)validateResponse.getMessage());
        }
        Bo tenantBo = this.boRepository.getBoWithValidate(dataRuleVo.getBoId());
        BoDataRule boDataRule = BoDataRuleStructMapper.MAPPER.toEntity(dataRuleVo);
        boDataRule.setId(null);
        boDataRule.setUniqueId(null);
        boDataRule.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        boDataRule.setVersion("0.0.0");
        boDataRule.setStatus(DataRuleStatus.fromCode((String)dataRuleVo.getStatus()).code());
        boDataRule.setRefBoId(tenantBo.getRefBoId());
        boDataRule.setTenantCode(tenantBo.getTenantCode());
        boDataRule.setTenantName(tenantBo.getTenantName());
        this.boDataRuleService.save((Object)boDataRule);
        ArrayList dataRuleDetails = Lists.newArrayList();
        Optional.ofNullable(dataRuleVo.getDetails()).ifPresent(details -> details.keySet().forEach(key -> {
            BoDataRuleDetail dataRuleDetail = BoDataRuleDetailStructMapper.MAPPER.toDetail((DataRuleDetailVo)dataRuleVo.getDetails().get(key));
            dataRuleDetail.setId(null);
            dataRuleDetail.setEntityAction(key);
            dataRuleDetail.setDataRuleId(boDataRule.getId());
            dataRuleDetail.setStatus(Optional.ofNullable(dataRuleDetail.getStatus()).orElse(DataRuleStatus.DISABLED.code()));
            dataRuleDetails.add(dataRuleDetail);
        }));
        if (!dataRuleDetails.isEmpty()) {
            this.boDataRuleDetailService.saveBatch((Collection)dataRuleDetails);
        }
        return ServiceResponse.success();
    }
}

