/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.base.Functions;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.bo.dto.BoApiInfoDTO;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoCreateType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoFieldStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoIndexStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoRelationshipStructMapper;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoStructMapper;
import com.xforceplus.ultraman.bocp.metadata.business.boapi.util.BoApiUtil;
import com.xforceplus.ultraman.bocp.metadata.common.CommonBusiness;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.metadata.translator.BoToWebTranslator;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.vo.BoEx;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldExtendVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoFieldVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoIndexVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoInfoVo;
import com.xforceplus.ultraman.bocp.metadata.vo.BoSimpleVo;
import com.xforceplus.ultraman.bocp.metadata.vo.RelationVo;
import com.xforceplus.ultraman.bocp.metadata.vo.RelationshipVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoApi;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoField;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IBoService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.extend.BoExtendQuery;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoApiRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoFieldRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoIndexRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.ModuleBoRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.tenant.BoIndexTenantQuery;
import com.xforceplus.ultraman.metadata.repository.bocp.tenant.BoTenantQuery;
import com.xforceplus.ultraman.metadata.repository.common.CommonService;
import com.xforceplus.ultraman.metadata.repository.common.DefaultModuleService;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantAppMetadataReferenceService;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoExService;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TenantBoExServiceImpl
implements ITenantBoExService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private CommonService commonService;
    @Autowired
    private IBoService boService;
    @Autowired
    private ModuleBoRepository moduleBoRepository;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoFieldRepository boFieldRepository;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoIndexRepository boIndexRepository;
    @Autowired
    private BoApiRepository boApiRepository;
    @Autowired
    private BoApiDetailRepository boApiDetailRepository;
    @Autowired
    private BoToWebTranslator boToWebTranslator;
    @Autowired
    private DefaultModuleService defaultModuleService;
    @Autowired
    private BoTenantQuery boTenantQuery;
    @Autowired
    private BoIndexTenantQuery boIndexTenantQuery;
    @Autowired
    private BoExtendQuery boExtendQuery;
    @Autowired
    private ITenantAppMetadataReferenceService tenantAppMetadataReferenceService;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public BoInfoVo getBoInfoById(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertId((Bo)tenantBo, stdBoIdMapping);
        Map<Long, Long> stdBoVersion2uniIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getId, Bo::getUniqueId));
        Map stdBoRelationshipVersion2uniIdMapping = this.appRefVersionMetadataService.getBoRelationshipVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        Map stdBoFieldVersion2uniIdMapping = this.appRefVersionMetadataService.getBoFieldVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        BoInfoVo boInfoVo = BoStructMapper.MAPPER.toInfoVo(tenantBo);
        ArrayList boRelationships = Lists.newArrayList();
        if (null != tenantBo.getParentBoId()) {
            Tuple2<List<BoFieldVo>, List<BoRelationship>> tpl = this.getParentBoFieldsAndRelationshipsByTenant(tenantBo.getAppId(), tenantBo.getParentBoId(), tenantBo.getTenantCode());
            ((List)tpl._1).forEach(o -> {
                o.setId(o.getPublishFieldId());
                IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
            });
            ((List)tpl._2).forEach(o -> {
                o.setId(o.getUniqueId());
                IdConvertUtil.convertId((BoRelationship)o, (Map)stdBoVersion2uniIdMapping);
            });
            boInfoVo.getFields().addAll((Collection)tpl._1);
            boRelationships.addAll((Collection)tpl._2);
            List parentBoIndexVoList = this.boIndexTenantQuery.getParentBoIndexes(tenantBo.getParentBoId(), tenantBo.getTenantCode()).stream().map(index -> BoIndexStructMapper.MAPPER.toVo(index).setParent(true).setId(index.getUniqueId())).collect(Collectors.toList());
            boInfoVo.getIndexes().addAll(parentBoIndexVoList);
        }
        Bo stdBo = this.boRepository.getBoWithValidate(tenantBo.getRefBoId());
        boInfoVo.getFields().addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getRefBoId()), false, false).stream().map(o -> {
            o.setId(o.getPublishFieldId());
            IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
            return o;
        }).collect(Collectors.toList()));
        List stdBoRelationships = this.boRelationshipRepository.getBoRelationships(stdBo.getId());
        stdBoRelationships.forEach(o -> {
            o.setId(o.getUniqueId());
            IdConvertUtil.convertId((BoRelationship)o, (Map)stdBoVersion2uniIdMapping);
        });
        boRelationships.addAll(stdBoRelationships);
        String appVersion = PublishFlag.PUBLISHED.code().equals(tenantBo.getPublishFlag()) ? "?v=" + appRef.getRefAppVersion() : "";
        Map<String, BoApiInfoDTO> apis = this.boApiRepository.getBoApis(stdBo.getId()).stream().collect(Collectors.toMap(BoApi::getCode, bApi -> BoApiUtil.convertToBoApiMap2((BoApi)bApi, (List)this.boApiDetailRepository.getBoApiDetailsByBoApiId(bApi.getId()), (String)appVersion)));
        boInfoVo.setApi(apis);
        List standardBoIndexVoList = this.boIndexRepository.getBoIndexes(stdBo.getId()).stream().map(index -> BoIndexStructMapper.MAPPER.toVo(index).setParent(true).setId(index.getUniqueId())).collect(Collectors.toList());
        boInfoVo.getIndexes().addAll(standardBoIndexVoList);
        boInfoVo.getFields().addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getId()), false, true));
        boRelationships.addAll(this.boRelationshipRepository.getBoRelationships(tenantBo.getId()));
        boInfoVo.getIndexes().addAll(this.boIndexRepository.getBoIndexes(tenantBoId).stream().map(arg_0 -> ((BoIndexStructMapper)BoIndexStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()));
        List childBos = this.boRepository.getBosByParentBoId(stdBo.getId(), PublishFlag.fromCode((String)stdBo.getPublishFlag()));
        if (!childBos.isEmpty()) {
            List childBoIds = childBos.stream().map(Bo::getId).collect(Collectors.toList());
            Map tenantBoMap = this.boService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).in(Bo::getRefBoId, childBoIds)).eq(Bo::getTenantCode, (Object)tenantBo.getTenantCode())).stream().collect(Collectors.toMap(Bo::getRefBoId, Functions.identity()));
            List updateChildBoVos = childBos.stream().map(childBo -> {
                Bo finalChildBo = tenantBoMap.getOrDefault(childBo.getId(), childBo);
                BoSimpleVo boSimpleVo = new BoSimpleVo();
                boSimpleVo.setId(finalChildBo.getId());
                boSimpleVo.setCode(finalChildBo.getCode());
                boSimpleVo.setName(finalChildBo.getName());
                return boSimpleVo;
            }).collect(Collectors.toList());
            boInfoVo.setSubEntities(updateChildBoVos);
        }
        ArrayList toManyRelations = Lists.newArrayList();
        boRelationships.forEach(boRelation -> {
            if (RelationType.OTO.code().equals(boRelation.getRelationType()) || RelationType.MTO.code().equals(boRelation.getRelationType())) {
                BoFieldVo boFieldVo = CommonBusiness.buildRelationField((BoRelationship)boRelation, (String)"relationship");
                Long vJoinBoId = stdBoIdMapping.getOrDefault(boRelation.getJoinBoId(), boRelation.getJoinBoId());
                this.boRepository.getBo(vJoinBoId).ifPresent(joinBo -> boFieldVo.getRelation().setBoCode(joinBo.getCode()));
                boInfoVo.getFields().add(boFieldVo);
            } else if (RelationType.OTM.code().equals(boRelation.getRelationType()) || RelationType.MTM.code().equals(boRelation.getRelationType())) {
                RelationVo relationVo = new RelationVo();
                relationVo.setBoId(boRelation.getJoinBoId());
                relationVo.setRelationName(boRelation.getRelationName());
                relationVo.setRelationCode(boRelation.getRelationCode());
                toManyRelations.add(relationVo);
            } else if (RelationType.MV.code().equals(boRelation.getRelationType())) {
                boInfoVo.getFields().add(CommonBusiness.buildRelationField((BoRelationship)boRelation, (String)"MultiValues"));
            }
        });
        boInfoVo.setToManyRelations((List)toManyRelations);
        return boInfoVo;
    }

    @Override
    public List<BoEx> getBos(Long tenantAppId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantAppId);
        List tenantBos = this.boRepository.getBos(tenantAppId.longValue()).stream().map(o -> BoStructMapper.MAPPER.toBoEx(o).setAppCustomType(AppCustomType.TENANT.code())).collect(Collectors.toList());
        List existStdBoIds = tenantBos.stream().map(Bo::getRefBoId).collect(Collectors.toList());
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.BO).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List stdBoExes = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> !existStdBoIds.contains(o.getUniqueId()) && StringUtils.isBlank((CharSequence)o.getTenantCode())).map(o -> BoStructMapper.MAPPER.toBoEx(o).setAppCustomType(AppCustomType.STANDARD.code()).setCustomDisabled(customDisabledIds.contains(o.getUniqueId()))).sorted(Comparator.comparing(Bo::getUniqueId).reversed()).collect(Collectors.toList());
        List allBoExes = ListUtils.union(tenantBos, (List)ListUtils.union(stdBoExes.stream().filter(o -> SysType.USER.code().equals(o.getSysType())).collect(Collectors.toList()), stdBoExes.stream().filter(o -> !SysType.USER.code().equals(o.getSysType())).collect(Collectors.toList())));
        this.boToWebTranslator.batchFillNames(allBoExes);
        return allBoExes;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse updateById(Bo tenantBo) {
        Bo origBo = this.boRepository.getBoWithValidate(tenantBo.getId());
        if (StringUtils.isNotBlank((CharSequence)tenantBo.getCode()) && !origBo.getCode().equals(tenantBo.getCode())) {
            return ServiceResponse.fail((String)"\u5bf9\u8c61\u4ee3\u7801\u4e0d\u5141\u8bb8\u4fee\u6539");
        }
        ServiceResponse serviceResponse = this.tenantAppMetadataReferenceService.updateBoReferences(origBo.getAppId(), origBo, tenantBo);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        this.boService.updateById((Object)tenantBo);
        return ServiceResponse.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public ServiceResponse saveBo(Long tenantAppId, BoInfoVo boInfoVo) {
        App tenantApp = this.appCustomValidator.validateTenantApp(tenantAppId);
        Bo stdVBo = this.appRefVersionMetadataService.getRefVersionBo(tenantAppId, boInfoVo.getId()).orElse(null);
        if (null == stdVBo) {
            return ServiceResponse.success((String)"\u67e5\u8be2\u4e0d\u5230\u6807\u51c6\u5bf9\u8c61");
        }
        ServiceResponse serviceResponse = this.validateStandardBo(tenantApp, stdVBo);
        if (!serviceResponse.isSuccess()) {
            return serviceResponse;
        }
        this.createBo(tenantApp, stdVBo);
        return ServiceResponse.success();
    }

    @Override
    public BoFieldExtendVo getBoFieldExtendInfo(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertId((Bo)tenantBo, stdBoIdMapping);
        BoFieldExtendVo boFieldExtendVo = new BoFieldExtendVo();
        boFieldExtendVo.setBoFields(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBoId), false, false));
        Map<Long, Long> stdBoVersion2uniIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getId, Bo::getUniqueId));
        Map stdBoRelationshipVersion2uniIdMapping = this.appRefVersionMetadataService.getBoRelationshipVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        Map stdBoFieldVersion2uniIdMapping = this.appRefVersionMetadataService.getBoFieldVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        boFieldExtendVo.getBoFields().addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getRefBoId()), false, true).stream().map(o -> {
            o.setId(o.getPublishFieldId());
            IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
            return o;
        }).collect(Collectors.toList()));
        if (null != tenantBo.getParentBoId()) {
            Map map = this.boExtendQuery.getParentBoInfo(tenantBo);
            boFieldExtendVo.setParentBoMap(map);
            boFieldExtendVo.getParentBoMap().forEach((key, value) -> value.getBoFields().forEach(o -> {
                o.setId(o.getPublishFieldId());
                IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
            }));
        }
        return boFieldExtendVo;
    }

    @Override
    public List<BoFieldVo> getFieldVos(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertId((Bo)tenantBo, stdBoIdMapping);
        Map<Long, Long> stdBoVersion2uniIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getId, Bo::getUniqueId));
        Map stdBoRelationshipVersion2uniIdMapping = this.appRefVersionMetadataService.getBoRelationshipVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        Map stdBoFieldVersion2uniIdMapping = this.appRefVersionMetadataService.getBoFieldVersion2uniIdMapping(new ArrayList<Long>(stdBoIdMapping.values()));
        ArrayList boFieldVos = Lists.newArrayList();
        if (null != tenantBo.getParentBoId()) {
            boFieldVos.addAll(this.getParentBoFieldVosByTenant(tenantBo.getAppId(), tenantBo.getParentBoId(), tenantBo.getTenantCode()).stream().map(o -> {
                o.setId(o.getPublishFieldId());
                IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
                return o;
            }).collect(Collectors.toList()));
        }
        boFieldVos.addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBoId), false, false));
        boFieldVos.addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getRefBoId()), false, true).stream().map(o -> {
            o.setId(o.getPublishFieldId());
            IdConvertUtil.convertId((BoFieldVo)o, (Map)stdBoVersion2uniIdMapping, (Map)stdBoFieldVersion2uniIdMapping, (Map)stdBoRelationshipVersion2uniIdMapping);
            return o;
        }).collect(Collectors.toList()));
        return boFieldVos;
    }

    @Override
    public ServiceResponse saveFields(Long tenantBoId, List<BoFieldVo> boFieldVos) {
        return null;
    }

    @Override
    public List<BoInfoVo> getRelBos(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        if (stdBos.isEmpty()) {
            return Lists.newArrayList();
        }
        IdConvertUtil.convertBoUniIdToVersionId((Bo)tenantBo, stdBos);
        List boIds = stdBos.stream().map(Bo::getId).collect(Collectors.toList());
        LambdaQueryWrapper joinBoWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).ne(Bo::getSysType, (Object)SysType.SYSTEM.code())).in(Bo::getId, boIds);
        if (BoType.DTO.code().equals(tenantBo.getBoType())) {
            joinBoWrapper.in(Bo::getBoType, (Object[])new String[]{BoType.DTO.code(), BoType.ENTITY.code()});
        } else {
            joinBoWrapper.in(Bo::getBoType, (Object[])new String[]{BoType.ENTITY.code(), BoType.EXTERNAL.code()});
        }
        List filterStdBos = this.boService.list((Wrapper)joinBoWrapper).stream().filter(bo -> !bo.getCode().equals(tenantBo.getCode())).collect(Collectors.toList());
        Map fStdBoFieldsMap = this.boFieldRepository.getBoFieldsByBoIds(boIds).stream().collect(Collectors.groupingBy(BoField::getBoId, Collectors.toList()));
        return filterStdBos.stream().map(o -> {
            BoInfoVo vo = BoStructMapper.MAPPER.toInfoVo(o);
            vo.setId(o.getUniqueId());
            vo.setFields((List)Lists.newArrayList());
            Optional.ofNullable(fStdBoFieldsMap.get(o.getId())).ifPresent(fields -> vo.getFields().addAll(fields.stream().map(field -> {
                BoFieldVo boFieldVo = BoFieldStructMapper.MAPPER.toVo(field);
                boFieldVo.setId(field.getUniqueId());
                return boFieldVo;
            }).collect(Collectors.toList())));
            Optional.ofNullable(fStdBoFieldsMap.get(o.getRefBoId())).ifPresent(fields -> vo.getFields().addAll(fields.stream().map(field -> {
                BoFieldVo boFieldVo = BoFieldStructMapper.MAPPER.toVo(field);
                boFieldVo.setId(field.getUniqueId());
                boFieldVo.setRefFieldId(field.getUniqueId());
                return boFieldVo;
            }).collect(Collectors.toList())));
            return vo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<RelationshipVo> getRelationships(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertId((Bo)tenantBo, stdBoIdMapping);
        Map stdBoMap = stdBos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        ArrayList relationshipVos = Lists.newArrayList();
        relationshipVos.addAll(this.boRelationshipRepository.getBoRelationships(tenantBoId).stream().map(o -> {
            IdConvertUtil.convertId((BoRelationship)o, (Map)stdBoIdMapping);
            return BoRelationshipStructMapper.MAPPER.toVo(o).setFromParent(false).setFromRef(false);
        }).collect(Collectors.toList()));
        if (null != tenantBo.getParentBoId()) {
            Optional.ofNullable(stdBoMap.get(tenantBo.getParentBoId())).ifPresent(parentBo -> relationshipVos.addAll(this.getParentBoRelationshipVosByTenant(tenantBo.getAppId(), parentBo.getId(), tenantBo.getTenantCode()).stream().sorted(Comparator.comparing(RelationshipVo::getLevel).reversed()).collect(Collectors.toList())));
        }
        String refBoName = Optional.ofNullable(stdBoMap.get(tenantBo.getRefBoId())).map(Bo::getName).orElse(null);
        Optional.ofNullable(stdBoMap.get(tenantBo.getRefBoId())).ifPresent(refBo -> relationshipVos.addAll(this.boRelationshipRepository.getBoRelationships(refBo.getId()).stream().map(relation -> BoRelationshipStructMapper.MAPPER.toVo(relation).setFromParent(false).setFromRef(true).setBoName(refBoName)).collect(Collectors.toList())));
        return relationshipVos.stream().map(relationshipVo -> {
            Optional.ofNullable(stdBoMap.get(relationshipVo.getJoinBoId())).ifPresent(joinBo -> relationshipVo.setJoinBoName(joinBo.getName()).setJoinBoId(joinBo.getUniqueId()));
            return relationshipVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<BoIndexVo> getBoIndexes(Long tenantBoId) {
        Bo tenantBo = this.boRepository.getBoWithValidate(tenantBoId);
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        IdConvertUtil.convertBoUniIdToVersionId((Bo)tenantBo, stdBos);
        ArrayList allBoIndexVoList = Lists.newArrayList();
        List boIndexVoList = this.boIndexRepository.getBoIndexes(tenantBoId).stream().map(arg_0 -> ((BoIndexStructMapper)BoIndexStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList());
        allBoIndexVoList.addAll(boIndexVoList);
        Map stdBoMap = stdBos.stream().collect(Collectors.toMap(Bo::getId, Function.identity()));
        Optional.ofNullable(stdBoMap.get(tenantBo.getRefBoId())).ifPresent(stdBo -> {
            List standardBoIndexVoList = this.boIndexRepository.getBoIndexes(stdBo.getId()).stream().map(index -> BoIndexStructMapper.MAPPER.toVo(index).setParent(true).setId(index.getUniqueId())).collect(Collectors.toList());
            allBoIndexVoList.addAll(standardBoIndexVoList);
            List parentBoIndexVoList = this.boIndexTenantQuery.getParentBoIndexes(stdBo.getId(), tenantBo.getTenantCode()).stream().map(index -> BoIndexStructMapper.MAPPER.toVo(index).setParent(true).setId(index.getUniqueId())).collect(Collectors.toList());
            allBoIndexVoList.addAll(parentBoIndexVoList);
        });
        return allBoIndexVoList;
    }

    private List<RelationshipVo> getParentBoRelationshipVosByTenant(Long tenantAppId, Long parentBoId, String tenantCode) {
        ArrayList boRelationshipVos = Lists.newArrayList();
        Bo mainBo = this.boRepository.getBo(parentBoId).orElse(null);
        if (null == mainBo) {
            return Lists.newArrayList();
        }
        if (mainBo.getParentBoId() != null) {
            List<RelationshipVo> parentRels = this.getParentBoRelationshipVosByTenant(tenantAppId, mainBo.getParentBoId(), tenantCode);
            boRelationshipVos.addAll(parentRels);
        }
        List list = this.boRelationshipRepository.getBoRelationships(mainBo.getId()).stream().map(relation -> BoRelationshipStructMapper.MAPPER.toVo(relation).setBoName(mainBo.getName()).setLevel(mainBo.getLevel()).setFromParent(true).setFromRef(false)).collect(Collectors.toList());
        boRelationshipVos.addAll(list);
        Bo tenantBo = this.boTenantQuery.geTenantBo(tenantAppId, mainBo.getId(), tenantCode);
        if (tenantBo != null) {
            list = this.boRelationshipRepository.getBoRelationships(tenantBo.getId()).stream().map(relation -> BoRelationshipStructMapper.MAPPER.toVo(relation).setBoName(tenantBo.getName()).setLevel(mainBo.getLevel()).setFromParent(true).setFromRef(true)).collect(Collectors.toList());
            boRelationshipVos.addAll(list);
        }
        return boRelationshipVos;
    }

    private ServiceResponse validateStandardBo(App tenantApp, Bo stdVersionBo) {
        Bo bo = this.boRepository.getBoWithValidate(stdVersionBo.getId());
        if (bo.getSyncBoId() != null) {
            return ServiceResponse.fail((String)"\u540c\u6b65\u5bf9\u8c61\u4e0d\u53ef\u79df\u6237\u5b9a\u5236");
        }
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionBo.getUniqueId().longValue(), MetadataType.BO);
        if (appRefSettingOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u6807\u51c6\u5bf9\u8c61\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        Bo tenantBo = (Bo)this.boService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Bo::getDeleteFlag, (Object)"1")).eq(Bo::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Bo::getAppId, (Object)tenantApp.getId())).eq(Bo::getRefBoId, (Object)stdVersionBo.getUniqueId())).eq(Bo::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantBo) {
            return ServiceResponse.fail((String)"\u79df\u6237\u5bf9\u8c61\u5b9a\u5236\u5df2\u5b58\u5728");
        }
        return ServiceResponse.success((String)"", (Object)bo);
    }

    private Bo createBo(App tenantApp, Bo stdVersionBo) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantApp.getId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getId, Bo::getUniqueId));
        IdConvertUtil.convertId((Bo)stdVersionBo, stdBoIdMapping);
        Bo tenantBo = BoStructMapper.MAPPER.clone(stdVersionBo);
        tenantBo.setId(null);
        tenantBo.setUniqueId(null);
        tenantBo.setPublishBoId(null);
        tenantBo.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        tenantBo.setVersion("0.0.0");
        tenantBo.setCustomType(CustomType.CUSTOM.code());
        tenantBo.setCreateType(BoCreateType.DEFAULT.code());
        tenantBo.setRefBoId(stdVersionBo.getUniqueId());
        tenantBo.setTenantCode(tenantApp.getTenantCode());
        tenantBo.setTenantName(tenantApp.getTenantName());
        tenantBo.setAppId(tenantApp.getId());
        this.boService.save((Object)tenantBo);
        Optional moduleOptional = this.defaultModuleService.getModule(tenantApp.getId().longValue());
        moduleOptional.ifPresent(module -> this.moduleBoRepository.createModuleBo(module.getId(), tenantBo.getId()));
        return tenantBo;
    }

    private List<BoFieldVo> getParentBoFieldVosByTenant(Long tenantAppId, Long parentBoId, String tenantCode) {
        Bo tenantBo;
        ArrayList boFieldVos = Lists.newArrayList();
        Bo mainBo = this.boRepository.getBo(parentBoId).orElse(null);
        if (null == mainBo) {
            return Lists.newArrayList();
        }
        if (mainBo.getParentBoId() != null) {
            List<BoFieldVo> parentFieldVos = this.getParentBoFieldVosByTenant(tenantAppId, mainBo.getParentBoId(), tenantCode);
            boFieldVos.addAll(parentFieldVos);
        }
        boFieldVos.addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(mainBo.getId()), true, false));
        Bo bo = tenantBo = StringUtils.isEmpty((CharSequence)tenantCode) ? null : this.boTenantQuery.geTenantBo(tenantAppId, mainBo.getId(), tenantCode);
        if (tenantBo != null) {
            boFieldVos.addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getId()), true, true));
        }
        return boFieldVos;
    }

    private Tuple2<List<BoFieldVo>, List<BoRelationship>> getParentBoFieldsAndRelationshipsByTenant(Long tenantAppId, Long parentBoId, String tenantCode) {
        Bo tenantBo;
        Tuple2 tpl = new Tuple2((Object)Lists.newArrayList(), (Object)Lists.newArrayList());
        Bo mainBo = this.boRepository.getBo(parentBoId).orElse(null);
        if (null == mainBo) {
            return tpl;
        }
        if (mainBo.getParentBoId() != null) {
            Tuple2<List<BoFieldVo>, List<BoRelationship>> parentTpl = this.getParentBoFieldsAndRelationshipsByTenant(tenantAppId, mainBo.getParentBoId(), tenantCode);
            ((List)tpl._1).addAll((Collection)parentTpl._1);
            ((List)tpl._2).addAll((Collection)parentTpl._2);
        }
        ((List)tpl._1).addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(mainBo.getId()), true, false));
        ((List)tpl._2).addAll(this.boRelationshipRepository.getBoRelationships(mainBo.getId()));
        Bo bo = tenantBo = StringUtils.isEmpty((CharSequence)tenantCode) ? null : this.boTenantQuery.geTenantBo(tenantAppId, mainBo.getId(), tenantCode);
        if (tenantBo != null) {
            ((List)tpl._1).addAll(this.commonService.convertBoFieldsToBoFieldVos(this.boFieldRepository.getBoFields(tenantBo.getId()), true, true));
            ((List)tpl._2).addAll(this.boRelationshipRepository.getBoRelationships(tenantBo.getId()));
        }
        return tpl;
    }
}

