/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.BoType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.FieldType;
import com.xforceplus.ultraman.bocp.metadata.bo.enums.RelationType;
import com.xforceplus.ultraman.bocp.metadata.bo.mapstruct.BoRelationshipStructMapper;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.StrongFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.ValidateRegex;
import com.xforceplus.ultraman.bocp.metadata.util.IdConvertUtil;
import com.xforceplus.ultraman.bocp.metadata.validator.CommonValidator;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.vo.RelationshipVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Bo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoFieldDomainAttribute;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.BoRelationship;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoFieldDomainAttributeMapper;
import com.xforceplus.ultraman.bocp.mybatisplus.mapper.BoRelationshipMapper;
import com.xforceplus.ultraman.metadata.repository.bocp.extend.BoExtendQuery;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRelationshipRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.BoRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantBoRelationshipExService;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Service
public class TenantBoRelationshipExServiceImpl
implements ITenantBoRelationshipExService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private BoRelationshipMapper boRelationshipMapper;
    @Autowired
    private BoRelationshipRepository boRelationshipRepository;
    @Autowired
    private BoRepository boRepository;
    @Autowired
    private BoExtendQuery boExtendQuery;
    @Autowired
    private BoFieldDomainAttributeMapper boFieldDomainAttributeMapper;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public ServiceResponse save(RelationshipVo relVo) {
        Optional parentBoRelationshipOptional;
        if (null == relVo.getBoId()) {
            return ServiceResponse.fail((String)"\u5bf9\u8c61Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (null == relVo.getJoinBoId()) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u5bf9\u8c61Id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)relVo.getRelationName())) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)relVo.getRelationCode())) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (!CommonValidator.check((ValidateRegex)ValidateRegex.CAMEL_CASE, (String)relVo.getRelationCode())) {
            return ServiceResponse.fail((String)("\u5173\u7cfb\u4ee3\u7801" + ValidateRegex.CAMEL_CASE.desc()));
        }
        if (!CommonValidator.check((ValidateRegex)ValidateRegex.NUM_AND_CHARACTER, (String)relVo.getRelationCode())) {
            return ServiceResponse.fail((String)("\u5173\u7cfb\u4ee3\u7801" + ValidateRegex.NUM_AND_CHARACTER.desc()));
        }
        if (StringUtils.isEmpty((CharSequence)relVo.getRelationType())) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u7c7b\u578b\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (RelationType.fromType((String)relVo.getRelationType()) == null) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u7c7b\u578b\u4e0d\u7b49\u4e8e\u4e00\u5bf9\u4e00\u3001\u591a\u5bf9\u4e00\u3001\u591a\u5bf9\u591a\u6216\u591a\u503c");
        }
        if (RelationType.OTM.code().equals(relVo.getRelationType())) {
            return ServiceResponse.fail((String)"\u79df\u6237\u5b9a\u5236\u76ee\u524d\u4e0d\u5141\u8bb8\u521b\u5efa\u4e00\u5bf9\u591a\u5173\u7cfb\u7c7b\u578b,\u53ef\u901a\u8fc7\u7ee7\u627f\u6807\u51c6\u5b57\u6bb5\u5b9e\u73b0");
        }
        Bo tenantBo = this.boRepository.getBoWithValidate(relVo.getBoId());
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
        List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        Map<Long, Long> boIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
        IdConvertUtil.convertId((Bo)tenantBo, boIdMapping);
        if (!boIdMapping.containsKey(relVo.getJoinBoId())) {
            return ServiceResponse.fail((String)"\u5173\u8054\u5bf9\u8c61\u5feb\u7167ID\u4e0d\u5b58\u5728");
        }
        Optional boRelationshipOptional = this.boRelationshipRepository.getBoRelationship(relVo.getBoId(), relVo.getRelationCode());
        if (boRelationshipOptional.isPresent()) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u5df2\u5b58\u5728");
        }
        if (null != tenantBo.getParentBoId() && (parentBoRelationshipOptional = this.boRelationshipRepository.getBoRelationship(tenantBo.getParentBoId(), relVo.getRelationCode())).isPresent()) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u5728\u7236\u7c7b\u4e2d\u5df2\u5b58\u5728");
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"delete_flag", (Object)"1")).eq((Object)"bo_id", (Object)relVo.getBoId())).eq((Object)"relation_code", (Object)relVo.getRelationCode())).eq((Object)"join_bo_id", (Object)relVo.getJoinBoId())).eq((Object)"relation_type", (Object)relVo.getRelationType());
        List boRelationships = this.boRelationshipMapper.selectList((Wrapper)wrapper);
        if (boRelationships.isEmpty()) {
            BoRelationship boRelationship = BoRelationshipStructMapper.MAPPER.toEntity(relVo);
            if (BoType.ENTITY.code().equals(tenantBo.getBoType()) || BoType.EXTERNAL.code().equals(tenantBo.getBoType())) {
                // empty if block
            }
            this.boRelationshipMapper.insert((Object)boRelationship);
        } else {
            BoRelationship boRelationship = (BoRelationship)boRelationships.get(0);
            boRelationship.setRelationName(relVo.getRelationName());
            boRelationship.setBoField(relVo.getBoField());
            boRelationship.setJoinField(relVo.getJoinField());
            boRelationship.setStrongFlag(StrongFlag.fromCode((String)relVo.getStrongFlag()).code());
            this.boRelationshipMapper.updateById((Object)boRelationship);
        }
        return ServiceResponse.success((String)"");
    }

    @Override
    public ServiceResponse remove(Long id) {
        int count;
        BoRelationship boRelationship = this.boRelationshipRepository.getBoRelationshipWithValidate(id);
        if (RelationType.MTO.code().equals(boRelationship.getRelationType()) && (count = this.boFieldDomainAttributeMapper.selectCount((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BoFieldDomainAttribute::getDeleteFlag, (Object)"1")).eq(BoFieldDomainAttribute::getType, (Object)FieldType.LOOKUP.code())).eq(BoFieldDomainAttribute::getLookupRelationId, (Object)boRelationship.getId())).eq(BoFieldDomainAttribute::getLookupBoId, (Object)boRelationship.getJoinBoId())).intValue()) > 0) {
            return ServiceResponse.fail((String)"\u5bf9\u8c61\u5b58\u5728\u4e0e\u8be5\u5173\u7cfb\u6709\u5173\u7684\u67e5\u627e\uff08Lookup\uff09\u5b57\u6bb5\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        BoRelationship updateRelation = new BoRelationship();
        updateRelation.setDeleteFlag("0");
        updateRelation.setId(id);
        this.boRelationshipMapper.updateById((Object)updateRelation);
        return ServiceResponse.success((String)"");
    }

    @Override
    public ServiceResponse update(RelationshipVo relVo) {
        if (StringUtils.isEmpty((CharSequence)relVo.getRelationName())) {
            return ServiceResponse.fail((String)"\u5173\u7cfb\u540d\u79f0\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        BoRelationship boRelationship = this.boRelationshipRepository.getBoRelationshipWithValidate(relVo.getId());
        Bo tenantBo = this.boRepository.getBoWithValidate(relVo.getBoId());
        if ("0.0.0".equals(tenantBo.getVersion())) {
            if (boRelationship.getRelationCode().equals(relVo.getRelationCode()) && boRelationship.getRelationName().equals(relVo.getRelationName())) {
                return ServiceResponse.success();
            }
            if (!boRelationship.getRelationCode().equals(relVo.getRelationCode())) {
                if (StringUtils.isEmpty((CharSequence)relVo.getRelationCode())) {
                    return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
                }
                if (!CommonValidator.check((ValidateRegex)ValidateRegex.CAMEL_CASE, (String)relVo.getRelationCode())) {
                    return ServiceResponse.fail((String)("\u5173\u7cfb\u4ee3\u7801" + ValidateRegex.CAMEL_CASE.desc()));
                }
                if (!CommonValidator.check((ValidateRegex)ValidateRegex.NUM_AND_CHARACTER, (String)relVo.getRelationCode())) {
                    return ServiceResponse.fail((String)("\u5173\u7cfb\u4ee3\u7801" + ValidateRegex.NUM_AND_CHARACTER.desc()));
                }
                QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bo_id", (Object)boRelationship.getBoId())).eq((Object)"relation_code", (Object)relVo.getRelationCode())).eq((Object)"delete_flag", (Object)"1");
                int count = this.boRelationshipMapper.selectCount((Wrapper)wrapper);
                if (count > 0) {
                    return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u5df2\u5b58\u5728");
                }
                AppRef appRef = this.appCustomValidator.validateAppRef(tenantBo.getAppId());
                List stdBos = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Bo.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
                Map<Long, Long> stdBoIdMapping = stdBos.stream().collect(Collectors.toMap(Bo::getUniqueId, Bo::getId));
                IdConvertUtil.convertId((Bo)tenantBo, stdBoIdMapping);
                if (this.boExtendQuery.checkSameRelCodeInParent(tenantBo, relVo.getRelationCode())) {
                    return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u5728\u7236\u7c7b\u4e2d\u5df2\u5b58\u5728");
                }
                if (tenantBo.getParentBoId() != null) {
                    Optional vParentBoOptional = this.appRefVersionMetadataService.getRefVersionBo(tenantBo.getAppId(), tenantBo.getParentBoId());
                    if (!vParentBoOptional.isPresent()) {
                        return ServiceResponse.fail((String)"\u67e5\u8be2\u4e0d\u5230\u7236\u7c7b\u5bf9\u8c61");
                    }
                    Optional parentBoRelationshipOptional = this.boRelationshipRepository.getBoRelationship(((Bo)vParentBoOptional.get()).getId(), relVo.getRelationCode());
                    if (parentBoRelationshipOptional.isPresent()) {
                        return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u5728\u7236\u7c7b\u4e2d\u5df2\u5b58\u5728");
                    }
                }
            }
        } else {
            if (!boRelationship.getRelationCode().equals(relVo.getRelationCode()) && !StringUtils.isEmpty((CharSequence)relVo.getRelationCode())) {
                return ServiceResponse.fail((String)"\u5173\u7cfb\u4ee3\u7801\u4e0d\u5141\u8bb8\u4fee\u6539");
            }
            if (relVo.getRelationName().equals(boRelationship.getRelationName())) {
                return ServiceResponse.success();
            }
        }
        if (BoType.ENTITY.code().equals(tenantBo.getBoType()) || BoType.EXTERNAL.code().equals(tenantBo.getBoType())) {
            // empty if block
        }
        boRelationship.setRelationName(relVo.getRelationName());
        if (!StringUtils.isEmpty((CharSequence)relVo.getRelationCode())) {
            boRelationship.setRelationCode(relVo.getRelationCode());
        }
        this.boRelationshipMapper.updateById((Object)boRelationship);
        return ServiceResponse.success((String)"");
    }
}

