/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.ultraman.metadata.tenant.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.xforceplus.ultraman.bocp.metadata.dto.ServiceResponse;
import com.xforceplus.ultraman.bocp.metadata.enums.CustomType;
import com.xforceplus.ultraman.bocp.metadata.enums.PublishFlag;
import com.xforceplus.ultraman.bocp.metadata.enums.SysType;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictDetailStructMapper;
import com.xforceplus.ultraman.bocp.metadata.mapstruct.DictStructMapper;
import com.xforceplus.ultraman.bocp.metadata.validator.custom.AppCustomValidator;
import com.xforceplus.ultraman.bocp.metadata.version.enums.MetadataType;
import com.xforceplus.ultraman.bocp.metadata.version.query.MetadataVersionQuery;
import com.xforceplus.ultraman.bocp.metadata.version.service.IAppRefVersionMetadataService;
import com.xforceplus.ultraman.bocp.metadata.vo.DictVo;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.App;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRef;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.AppRefSetting;
import com.xforceplus.ultraman.bocp.mybatisplus.entity.Dict;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictDetailService;
import com.xforceplus.ultraman.bocp.mybatisplus.service.IDictService;
import com.xforceplus.ultraman.metadata.global.common.enums.AppCustomType;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.AppRefSettingRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictDetailRepository;
import com.xforceplus.ultraman.metadata.repository.bocp.repository.DictRepository;
import com.xforceplus.ultraman.metadata.tenant.service.ITenantDictExService;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TenantDictExServiceImpl
implements ITenantDictExService {
    @Autowired
    private AppCustomValidator appCustomValidator;
    @Autowired
    private IDictService dictService;
    @Autowired
    private IDictDetailService dictDetailService;
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictDetailRepository dictDetailRepository;
    @Autowired
    private IAppRefVersionMetadataService appRefVersionMetadataService;
    @Autowired
    private AppRefSettingRepository appRefSettingRepository;
    @Autowired
    private MetadataVersionQuery metadataVersionQuery;

    @Override
    public List<DictVo> getDictVosByAppId(Long tenantAppId) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantAppId);
        List tenantDictVos = this.dictRepository.getDicts(tenantAppId).stream().map(o -> DictStructMapper.MAPPER.toVo(o).setAppCustomType(AppCustomType.TENANT.code())).collect(Collectors.toList());
        List customDisabledIds = this.appRefSettingRepository.getAppRefSettingsByAppIdAndResourceType(appRef.getRefAppId().longValue(), MetadataType.BO).stream().map(AppRefSetting::getResourceId).collect(Collectors.toList());
        List excludeDictIds = tenantDictVos.stream().map(DictVo::getRefDictId).collect(Collectors.toList());
        List stdDictVos = this.getStdDictVos(appRef).stream().filter(o -> !excludeDictIds.contains(o.getPublishDictId()) && StringUtils.isBlank((CharSequence)o.getTenantCode())).map(o -> o.setCustomDisabled(customDisabledIds.contains(o.getUniqueId()))).collect(Collectors.toList());
        return ListUtils.union(tenantDictVos, (List)ListUtils.union(stdDictVos.stream().filter(o -> SysType.USER.code().equals(o.getSystemType())).collect(Collectors.toList()), stdDictVos.stream().filter(o -> !SysType.USER.code().equals(o.getSystemType())).collect(Collectors.toList())));
    }

    @Override
    public List<DictVo> getDictVoAllInfosByAppId(Long tenantAppId) {
        return this.getDictVoAllInfos(tenantAppId, this.dictRepository.getDicts(tenantAppId));
    }

    @Override
    public List<DictVo> getDictVoAllInfosByIds(List<Long> dictIds) {
        if (CollectionUtils.isEmpty(dictIds)) {
            return Lists.newArrayList();
        }
        List tenantDicts = this.dictRepository.getDicts(dictIds);
        return tenantDicts.isEmpty() ? Lists.newArrayList() : this.getDictVoAllInfos(((Dict)tenantDicts.get(0)).getAppId(), tenantDicts);
    }

    private List<DictVo> getDictVoAllInfos(Long tenantAppId, List<Dict> tenantDicts) {
        AppRef appRef = this.appCustomValidator.validateAppRef(tenantAppId);
        List<DictVo> tenantDictVos = tenantDicts.stream().map(o -> DictStructMapper.MAPPER.toVo(o).setAppCustomType(AppCustomType.TENANT.code())).collect(Collectors.toList());
        List excludeDictIds = tenantDictVos.stream().map(DictVo::getRefDictId).collect(Collectors.toList());
        List<DictVo> stdDictVos = this.getStdDictVos(appRef).stream().filter(dict -> !excludeDictIds.contains(dict.getPublishDictId())).collect(Collectors.toList());
        this.fillDictDetailVos(tenantDictVos);
        this.fillDictDetailVos(stdDictVos);
        tenantDictVos.forEach(o -> o.setId(o.getRefDictId()).setUniqueId(o.getRefDictId()).setPublishDictId(o.getRefDictId()));
        stdDictVos.forEach(o -> o.setId(o.getUniqueId()));
        return ListUtils.union(tenantDictVos, (List)ListUtils.union(stdDictVos.stream().filter(o -> SysType.USER.code().equals(o.getCode())).collect(Collectors.toList()), stdDictVos.stream().filter(o -> !SysType.USER.code().equals(o.getCode())).collect(Collectors.toList())));
    }

    private List<DictVo> getStdDictVos(AppRef appRef) {
        List stdDicts = this.metadataVersionQuery.getMetadataByTypeSkipDataAuth(appRef.getRefAppId(), appRef.getRefAppVersion(), Dict.class).stream().filter(o -> StringUtils.isBlank((CharSequence)o.getTenantCode())).collect(Collectors.toList());
        return stdDicts.stream().map(o -> DictStructMapper.MAPPER.toVo(o).setAppCustomType(AppCustomType.STANDARD.code())).collect(Collectors.toList());
    }

    @Override
    public ServiceResponse saveDict(DictVo dictVo) {
        App tenantApp = this.appCustomValidator.validateTenantApp(dictVo.getAppId());
        Optional stdVDictOptional = this.appRefVersionMetadataService.getRefVersionDict(dictVo.getAppId(), dictVo.getId());
        if (!stdVDictOptional.isPresent()) {
            return ServiceResponse.success((String)"\u6807\u51c6\u5b57\u5178\u4e0d\u5b58\u5728");
        }
        this.validateStandardDict(tenantApp, (Dict)stdVDictOptional.get());
        this.createDict(tenantApp, (Dict)stdVDictOptional.get(), dictVo);
        return ServiceResponse.success();
    }

    private Dict createDict(App tenantApp, Dict stdVersionDict, DictVo dictVo) {
        Dict tenantDict = DictStructMapper.MAPPER.clone(stdVersionDict);
        tenantDict.setId(null);
        tenantDict.setUniqueId(null);
        tenantDict.setPublishDictId(null);
        tenantDict.setPublishFlag(PublishFlag.UNPUBLISHED.code());
        tenantDict.setVersion("0.0.0");
        tenantDict.setCustomType(CustomType.CUSTOM.code());
        tenantDict.setRefDictId(stdVersionDict.getUniqueId());
        tenantDict.setTenantCode(tenantApp.getTenantCode());
        tenantDict.setTenantName(tenantApp.getTenantName());
        tenantDict.setAppId(tenantApp.getId());
        this.dictService.save((Object)tenantDict);
        List dictDetails = Optional.ofNullable(dictVo.getOptions()).map(options -> options.stream().map(arg_0 -> ((DictDetailStructMapper)DictDetailStructMapper.MAPPER).toEntity(arg_0)).collect(Collectors.toList())).orElse(Lists.newArrayList());
        dictDetails.forEach(o -> o.setId(null).setUniqueId(null).setDictId(tenantDict.getId()).setVersion("0.0.0"));
        if (!dictDetails.isEmpty()) {
            this.dictDetailService.saveBatch((Collection)dictDetails);
        }
        return tenantDict;
    }

    private void fillDictDetailVos(List<DictVo> dictVos) {
        Map dictDetailVosMap = this.dictDetailRepository.getDictDetailMapByDictIds(dictVos.stream().map(DictVo::getId).collect(Collectors.toList()));
        dictVos.forEach(dictVo -> Optional.ofNullable(dictDetailVosMap.get(dictVo.getId())).ifPresent(dictDetails -> dictVo.setOptions(dictDetails.stream().map(arg_0 -> ((DictDetailStructMapper)DictDetailStructMapper.MAPPER).toVo(arg_0)).collect(Collectors.toList()))));
    }

    private void validateStandardDict(App tenantApp, Dict stdVersionDict) {
        this.dictRepository.getDictWithValidate(stdVersionDict.getId());
        Optional appRefSettingOptional = this.appRefSettingRepository.getAppRefSetting(stdVersionDict.getUniqueId().longValue(), MetadataType.DICT);
        if (appRefSettingOptional.isPresent()) {
            throw new RuntimeException("\u8be5\u6807\u51c6\u5b57\u5178\u4e0d\u5141\u8bb8\u5b9a\u5236");
        }
        Dict tenantDict = (Dict)this.dictService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(Dict::getDeleteFlag, (Object)"1")).eq(Dict::getPublishFlag, (Object)PublishFlag.UNPUBLISHED.code())).eq(Dict::getAppId, (Object)tenantApp.getId())).eq(Dict::getRefDictId, (Object)stdVersionDict.getUniqueId())).eq(Dict::getTenantCode, (Object)tenantApp.getTenantCode()), false);
        if (null != tenantDict) {
            throw new RuntimeException("\u5b57\u5178\u79df\u6237\u5b9a\u5236\u5df2\u5b58\u5728");
        }
    }
}

